/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.history.producer;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.DelegateTask;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.externaltask.ExternalTask;
import org.camunda.bpm.engine.history.ExternalTaskState;
import org.camunda.bpm.engine.history.IncidentState;
import org.camunda.bpm.engine.history.JobState;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.batch.BatchEntity;
import org.camunda.bpm.engine.impl.batch.history.HistoricBatchEntity;
import org.camunda.bpm.engine.impl.cfg.ConfigurationLogger;
import org.camunda.bpm.engine.impl.cfg.IdGenerator;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.history.DefaultHistoryRemovalTimeProvider;
import org.camunda.bpm.engine.impl.history.event.HistoricActivityInstanceEventEntity;
import org.camunda.bpm.engine.impl.history.event.HistoricExternalTaskLogEntity;
import org.camunda.bpm.engine.impl.history.event.HistoricFormPropertyEventEntity;
import org.camunda.bpm.engine.impl.history.event.HistoricIdentityLinkLogEventEntity;
import org.camunda.bpm.engine.impl.history.event.HistoricIncidentEventEntity;
import org.camunda.bpm.engine.impl.history.event.HistoricProcessInstanceEventEntity;
import org.camunda.bpm.engine.impl.history.event.HistoricTaskInstanceEventEntity;
import org.camunda.bpm.engine.impl.history.event.HistoricVariableUpdateEventEntity;
import org.camunda.bpm.engine.impl.history.event.HistoryEvent;
import org.camunda.bpm.engine.impl.history.event.HistoryEventType;
import org.camunda.bpm.engine.impl.history.event.HistoryEventTypes;
import org.camunda.bpm.engine.impl.history.event.UserOperationLogEntryEventEntity;
import org.camunda.bpm.engine.impl.history.producer.HistoryEventProducer;
import org.camunda.bpm.engine.impl.migration.instance.MigratingActivityInstance;
import org.camunda.bpm.engine.impl.oplog.UserOperationLogContext;
import org.camunda.bpm.engine.impl.oplog.UserOperationLogContextEntry;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExternalTaskEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricJobLogEventEntity;
import org.camunda.bpm.engine.impl.persistence.entity.IncidentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.camunda.bpm.engine.impl.pvm.PvmScope;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.CompensationBehavior;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.impl.util.ExceptionUtil;
import org.camunda.bpm.engine.impl.util.ParseUtil;
import org.camunda.bpm.engine.impl.util.StringUtil;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ResourceTypes;
import org.camunda.bpm.engine.runtime.Incident;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.task.IdentityLink;

public class DefaultHistoryEventProducer
implements HistoryEventProducer {
    protected static final ConfigurationLogger LOG = ProcessEngineLogger.CONFIG_LOGGER;

    protected void initActivityInstanceEvent(HistoricActivityInstanceEventEntity evt, ExecutionEntity execution, HistoryEventType eventType) {
        PvmScope eventSource = execution.getActivity();
        if (eventSource == null) {
            eventSource = (PvmScope)((Object)execution.getEventSource());
        }
        String activityInstanceId = execution.getActivityInstanceId();
        String parentActivityInstanceId = null;
        ExecutionEntity parentExecution = execution.getParent();
        parentActivityInstanceId = parentExecution != null && CompensationBehavior.isCompensationThrowing(parentExecution) && execution.getActivity() != null ? CompensationBehavior.getParentActivityInstanceId(execution) : execution.getParentActivityInstanceId();
        this.initActivityInstanceEvent(evt, execution, eventSource, activityInstanceId, parentActivityInstanceId, eventType);
    }

    protected void initActivityInstanceEvent(HistoricActivityInstanceEventEntity evt, MigratingActivityInstance migratingActivityInstance, HistoryEventType eventType) {
        ScopeImpl eventSource = migratingActivityInstance.getTargetScope();
        String activityInstanceId = migratingActivityInstance.getActivityInstanceId();
        MigratingActivityInstance parentInstance = migratingActivityInstance.getParent();
        String parentActivityInstanceId = null;
        if (parentInstance != null) {
            parentActivityInstanceId = parentInstance.getActivityInstanceId();
        }
        ExecutionEntity execution = migratingActivityInstance.resolveRepresentativeExecution();
        this.initActivityInstanceEvent(evt, execution, eventSource, activityInstanceId, parentActivityInstanceId, eventType);
    }

    protected void initActivityInstanceEvent(HistoricActivityInstanceEventEntity evt, ExecutionEntity execution, PvmScope eventSource, String activityInstanceId, String parentActivityInstanceId, HistoryEventType eventType) {
        CaseExecutionEntity subCaseInstance;
        ProcessDefinitionEntity definition;
        evt.setId(activityInstanceId);
        evt.setEventType(eventType.getEventName());
        evt.setActivityInstanceId(activityInstanceId);
        evt.setParentActivityInstanceId(parentActivityInstanceId);
        evt.setProcessDefinitionId(execution.getProcessDefinitionId());
        evt.setProcessInstanceId(execution.getProcessInstanceId());
        evt.setExecutionId(execution.getId());
        evt.setTenantId(execution.getTenantId());
        evt.setRootProcessInstanceId(execution.getRootProcessInstanceId());
        if (this.isHistoryRemovalTimeStrategyStart()) {
            this.provideRemovalTime(evt);
        }
        if ((definition = execution.getProcessDefinition()) != null) {
            evt.setProcessDefinitionKey(definition.getKey());
        }
        evt.setActivityId(eventSource.getId());
        evt.setActivityName((String)eventSource.getProperty("name"));
        evt.setActivityType((String)eventSource.getProperty("type"));
        ExecutionEntity subProcessInstance = execution.getSubProcessInstance();
        if (subProcessInstance != null) {
            evt.setCalledProcessInstanceId(subProcessInstance.getId());
        }
        if ((subCaseInstance = execution.getSubCaseInstance()) != null) {
            evt.setCalledCaseInstanceId(subCaseInstance.getId());
        }
    }

    protected void initProcessInstanceEvent(HistoricProcessInstanceEventEntity evt, ExecutionEntity execution, HistoryEventType eventType) {
        String processDefinitionId = execution.getProcessDefinitionId();
        String processInstanceId = execution.getProcessInstanceId();
        String executionId = execution.getId();
        String caseInstanceId = execution.getCaseInstanceId();
        String tenantId = execution.getTenantId();
        ProcessDefinitionEntity definition = execution.getProcessDefinition();
        String processDefinitionKey = null;
        if (definition != null) {
            processDefinitionKey = definition.getKey();
        }
        evt.setId(processInstanceId);
        evt.setEventType(eventType.getEventName());
        evt.setProcessDefinitionKey(processDefinitionKey);
        evt.setProcessDefinitionId(processDefinitionId);
        evt.setProcessInstanceId(processInstanceId);
        evt.setExecutionId(executionId);
        evt.setBusinessKey(execution.getProcessBusinessKey());
        evt.setCaseInstanceId(caseInstanceId);
        evt.setTenantId(tenantId);
        evt.setRootProcessInstanceId(execution.getRootProcessInstanceId());
        if (execution.getSuperCaseExecution() != null) {
            evt.setSuperCaseInstanceId(execution.getSuperCaseExecution().getCaseInstanceId());
        }
        if (execution.getSuperExecution() != null) {
            evt.setSuperProcessInstanceId(execution.getSuperExecution().getProcessInstanceId());
        }
    }

    protected void initTaskInstanceEvent(HistoricTaskInstanceEventEntity evt, TaskEntity taskEntity, HistoryEventType eventType) {
        String processDefinitionKey = null;
        ProcessDefinitionEntity definition = taskEntity.getProcessDefinition();
        if (definition != null) {
            processDefinitionKey = definition.getKey();
        }
        String processDefinitionId = taskEntity.getProcessDefinitionId();
        String processInstanceId = taskEntity.getProcessInstanceId();
        String executionId = taskEntity.getExecutionId();
        String caseDefinitionKey = null;
        CaseDefinitionEntity caseDefinition = taskEntity.getCaseDefinition();
        if (caseDefinition != null) {
            caseDefinitionKey = caseDefinition.getKey();
        }
        String caseDefinitionId = taskEntity.getCaseDefinitionId();
        String caseExecutionId = taskEntity.getCaseExecutionId();
        String caseInstanceId = taskEntity.getCaseInstanceId();
        String tenantId = taskEntity.getTenantId();
        evt.setId(taskEntity.getId());
        evt.setEventType(eventType.getEventName());
        evt.setTaskId(taskEntity.getId());
        evt.setProcessDefinitionKey(processDefinitionKey);
        evt.setProcessDefinitionId(processDefinitionId);
        evt.setProcessInstanceId(processInstanceId);
        evt.setExecutionId(executionId);
        evt.setCaseDefinitionKey(caseDefinitionKey);
        evt.setCaseDefinitionId(caseDefinitionId);
        evt.setCaseExecutionId(caseExecutionId);
        evt.setCaseInstanceId(caseInstanceId);
        evt.setAssignee(taskEntity.getAssignee());
        evt.setDescription(taskEntity.getDescription());
        evt.setDueDate(taskEntity.getDueDate());
        evt.setFollowUpDate(taskEntity.getFollowUpDate());
        evt.setName(taskEntity.getName());
        evt.setOwner(taskEntity.getOwner());
        evt.setParentTaskId(taskEntity.getParentTaskId());
        evt.setPriority(taskEntity.getPriority());
        evt.setTaskDefinitionKey(taskEntity.getTaskDefinitionKey());
        evt.setTenantId(tenantId);
        ExecutionEntity execution = taskEntity.getExecution();
        if (execution != null) {
            evt.setActivityInstanceId(execution.getActivityInstanceId());
            evt.setRootProcessInstanceId(execution.getRootProcessInstanceId());
            if (this.isHistoryRemovalTimeStrategyStart()) {
                this.provideRemovalTime(evt);
            }
        }
    }

    protected void initHistoricVariableUpdateEvt(HistoricVariableUpdateEventEntity evt, VariableInstanceEntity variableInstance, HistoryEventType eventType) {
        CaseDefinitionEntity definition;
        CaseExecutionEntity caseExecution;
        evt.setEventType(eventType.getEventName());
        evt.setTimestamp(ClockUtil.getCurrentTime());
        evt.setVariableInstanceId(variableInstance.getId());
        evt.setProcessInstanceId(variableInstance.getProcessInstanceId());
        evt.setExecutionId(variableInstance.getExecutionId());
        evt.setCaseInstanceId(variableInstance.getCaseInstanceId());
        evt.setCaseExecutionId(variableInstance.getCaseExecutionId());
        evt.setTaskId(variableInstance.getTaskId());
        evt.setRevision(variableInstance.getRevision());
        evt.setVariableName(variableInstance.getName());
        evt.setSerializerName(variableInstance.getSerializerName());
        evt.setTenantId(variableInstance.getTenantId());
        evt.setUserOperationId(Context.getCommandContext().getOperationId());
        ExecutionEntity execution = variableInstance.getExecution();
        if (execution != null) {
            ProcessDefinitionEntity definition2 = execution.getProcessDefinition();
            if (definition2 != null) {
                evt.setProcessDefinitionId(definition2.getId());
                evt.setProcessDefinitionKey(definition2.getKey());
            }
            evt.setRootProcessInstanceId(execution.getRootProcessInstanceId());
            if (this.isHistoryRemovalTimeStrategyStart()) {
                this.provideRemovalTime(evt);
            }
        }
        if ((caseExecution = variableInstance.getCaseExecution()) != null && (definition = (CaseDefinitionEntity)caseExecution.getCaseDefinition()) != null) {
            evt.setCaseDefinitionId(definition.getId());
            evt.setCaseDefinitionKey(definition.getKey());
        }
        evt.setTextValue(variableInstance.getTextValue());
        evt.setTextValue2(variableInstance.getTextValue2());
        evt.setDoubleValue(variableInstance.getDoubleValue());
        evt.setLongValue(variableInstance.getLongValue());
        if (variableInstance.getByteArrayValueId() != null) {
            evt.setByteValue(variableInstance.getByteArrayValue());
        }
    }

    protected void initUserOperationLogEvent(UserOperationLogEntryEventEntity evt, UserOperationLogContext context, UserOperationLogContextEntry contextEntry, PropertyChange propertyChange) {
        evt.setDeploymentId(contextEntry.getDeploymentId());
        evt.setEntityType(contextEntry.getEntityType());
        evt.setOperationType(contextEntry.getOperationType());
        evt.setOperationId(context.getOperationId());
        evt.setUserId(context.getUserId());
        evt.setProcessDefinitionId(contextEntry.getProcessDefinitionId());
        evt.setProcessDefinitionKey(contextEntry.getProcessDefinitionKey());
        evt.setProcessInstanceId(contextEntry.getProcessInstanceId());
        evt.setExecutionId(contextEntry.getExecutionId());
        evt.setCaseDefinitionId(contextEntry.getCaseDefinitionId());
        evt.setCaseInstanceId(contextEntry.getCaseInstanceId());
        evt.setCaseExecutionId(contextEntry.getCaseExecutionId());
        evt.setTaskId(contextEntry.getTaskId());
        evt.setJobId(contextEntry.getJobId());
        evt.setJobDefinitionId(contextEntry.getJobDefinitionId());
        evt.setBatchId(contextEntry.getBatchId());
        evt.setCategory(contextEntry.getCategory());
        evt.setTimestamp(ClockUtil.getCurrentTime());
        evt.setRootProcessInstanceId(contextEntry.getRootProcessInstanceId());
        evt.setExternalTaskId(contextEntry.getExternalTaskId());
        evt.setAnnotation(contextEntry.getAnnotation());
        evt.setTenantId(contextEntry.getTenantId());
        if (this.isHistoryRemovalTimeStrategyStart()) {
            this.provideRemovalTime(evt);
        }
        evt.setProperty(propertyChange.getPropertyName());
        evt.setOrgValue(propertyChange.getOrgValueString());
        evt.setNewValue(propertyChange.getNewValueString());
    }

    protected void initHistoricIncidentEvent(HistoricIncidentEventEntity evt, Incident incident, HistoryEventType eventType) {
        ExecutionEntity execution;
        IncidentEntity incidentEntity;
        ProcessDefinitionEntity definition;
        HistoricBatchEntity historicBatch;
        evt.setId(incident.getId());
        evt.setProcessDefinitionId(incident.getProcessDefinitionId());
        evt.setProcessInstanceId(incident.getProcessInstanceId());
        evt.setExecutionId(incident.getExecutionId());
        evt.setCreateTime(incident.getIncidentTimestamp());
        evt.setIncidentType(incident.getIncidentType());
        evt.setActivityId(incident.getActivityId());
        evt.setCauseIncidentId(incident.getCauseIncidentId());
        evt.setRootCauseIncidentId(incident.getRootCauseIncidentId());
        evt.setConfiguration(incident.getConfiguration());
        evt.setIncidentMessage(incident.getIncidentMessage());
        evt.setTenantId(incident.getTenantId());
        evt.setJobDefinitionId(incident.getJobDefinitionId());
        evt.setHistoryConfiguration(incident.getHistoryConfiguration());
        evt.setFailedActivityId(incident.getFailedActivityId());
        evt.setAnnotation(incident.getAnnotation());
        String jobId = incident.getConfiguration();
        if (jobId != null && this.isHistoryRemovalTimeStrategyStart() && (historicBatch = this.getHistoricBatchByJobId(jobId)) != null) {
            evt.setRemovalTime(historicBatch.getRemovalTime());
        }
        if ((definition = (incidentEntity = (IncidentEntity)incident).getProcessDefinition()) != null) {
            evt.setProcessDefinitionKey(definition.getKey());
        }
        if ((execution = incidentEntity.getExecution()) != null) {
            evt.setRootProcessInstanceId(execution.getRootProcessInstanceId());
            if (this.isHistoryRemovalTimeStrategyStart()) {
                this.provideRemovalTime(evt);
            }
        }
        evt.setEventType(eventType.getEventName());
        IncidentState incidentState = IncidentState.DEFAULT;
        if (HistoryEventTypes.INCIDENT_DELETE.equals(eventType)) {
            incidentState = IncidentState.DELETED;
        } else if (HistoryEventTypes.INCIDENT_RESOLVE.equals(eventType)) {
            incidentState = IncidentState.RESOLVED;
        }
        evt.setIncidentState(incidentState.getStateCode());
    }

    protected HistoryEvent createHistoricVariableEvent(VariableInstanceEntity variableInstance, VariableScope sourceVariableScope, HistoryEventType eventType) {
        String scopeActivityInstanceId = null;
        String sourceActivityInstanceId = null;
        if (variableInstance.getExecutionId() != null) {
            ExecutionEntity scopeExecution = Context.getCommandContext().getDbEntityManager().selectById(ExecutionEntity.class, variableInstance.getExecutionId());
            scopeActivityInstanceId = variableInstance.getTaskId() == null && !variableInstance.isConcurrentLocal() ? scopeExecution.getParentActivityInstanceId() : scopeExecution.getActivityInstanceId();
        } else if (variableInstance.getCaseExecutionId() != null) {
            scopeActivityInstanceId = variableInstance.getCaseExecutionId();
        }
        ExecutionEntity sourceExecution = null;
        CaseExecutionEntity sourceCaseExecution = null;
        if (sourceVariableScope instanceof ExecutionEntity) {
            sourceExecution = (ExecutionEntity)sourceVariableScope;
            sourceActivityInstanceId = sourceExecution.getActivityInstanceId();
        } else if (sourceVariableScope instanceof TaskEntity) {
            sourceExecution = ((TaskEntity)sourceVariableScope).getExecution();
            if (sourceExecution != null) {
                sourceActivityInstanceId = sourceExecution.getActivityInstanceId();
            } else {
                sourceCaseExecution = ((TaskEntity)sourceVariableScope).getCaseExecution();
                if (sourceCaseExecution != null) {
                    sourceActivityInstanceId = sourceCaseExecution.getId();
                }
            }
        } else if (sourceVariableScope instanceof CaseExecutionEntity) {
            sourceCaseExecution = (CaseExecutionEntity)sourceVariableScope;
            sourceActivityInstanceId = sourceCaseExecution.getId();
        }
        HistoricVariableUpdateEventEntity evt = this.newVariableUpdateEventEntity(sourceExecution);
        this.initHistoricVariableUpdateEvt(evt, variableInstance, eventType);
        this.initSequenceCounter(variableInstance, (HistoryEvent)evt);
        evt.setScopeActivityInstanceId(scopeActivityInstanceId);
        evt.setActivityInstanceId(sourceActivityInstanceId);
        if (sourceExecution != null && sourceExecution.isProcessInstanceStarting() && HistoryEventTypes.VARIABLE_INSTANCE_CREATE.equals(eventType)) {
            if (variableInstance.getSequenceCounter() == 1L) {
                evt.setInitial(true);
            }
            if (sourceActivityInstanceId == null && sourceExecution.getActivity() != null && sourceExecution.getTransition() == null) {
                evt.setActivityInstanceId(sourceExecution.getProcessInstanceId());
            }
        }
        return evt;
    }

    protected HistoricProcessInstanceEventEntity newProcessInstanceEventEntity(ExecutionEntity execution) {
        return new HistoricProcessInstanceEventEntity();
    }

    protected HistoricActivityInstanceEventEntity newActivityInstanceEventEntity(ExecutionEntity execution) {
        return new HistoricActivityInstanceEventEntity();
    }

    protected HistoricTaskInstanceEventEntity newTaskInstanceEventEntity(DelegateTask task) {
        return new HistoricTaskInstanceEventEntity();
    }

    protected HistoricVariableUpdateEventEntity newVariableUpdateEventEntity(ExecutionEntity execution) {
        return new HistoricVariableUpdateEventEntity();
    }

    protected HistoricFormPropertyEventEntity newHistoricFormPropertyEvent() {
        return new HistoricFormPropertyEventEntity();
    }

    protected HistoricIncidentEventEntity newIncidentEventEntity(Incident incident) {
        return new HistoricIncidentEventEntity();
    }

    protected HistoricJobLogEventEntity newHistoricJobLogEntity(Job job) {
        return new HistoricJobLogEventEntity();
    }

    protected HistoricBatchEntity newBatchEventEntity(BatchEntity batch) {
        return new HistoricBatchEntity();
    }

    protected HistoricProcessInstanceEventEntity loadProcessInstanceEventEntity(ExecutionEntity execution) {
        return this.newProcessInstanceEventEntity(execution);
    }

    protected HistoricActivityInstanceEventEntity loadActivityInstanceEventEntity(ExecutionEntity execution) {
        return this.newActivityInstanceEventEntity(execution);
    }

    protected HistoricTaskInstanceEventEntity loadTaskInstanceEvent(DelegateTask task) {
        return this.newTaskInstanceEventEntity(task);
    }

    protected HistoricIncidentEventEntity loadIncidentEvent(Incident incident) {
        return this.newIncidentEventEntity(incident);
    }

    protected HistoricBatchEntity loadBatchEntity(BatchEntity batch) {
        return this.newBatchEventEntity(batch);
    }

    @Override
    public HistoryEvent createProcessInstanceStartEvt(DelegateExecution execution) {
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        HistoricProcessInstanceEventEntity evt = this.newProcessInstanceEventEntity(executionEntity);
        this.initProcessInstanceEvent(evt, executionEntity, HistoryEventTypes.PROCESS_INSTANCE_START);
        evt.setStartActivityId(executionEntity.getActivityId());
        evt.setStartTime(ClockUtil.getCurrentTime());
        ExecutionEntity superExecution = executionEntity.getSuperExecution();
        if (superExecution != null) {
            evt.setSuperProcessInstanceId(superExecution.getProcessInstanceId());
        }
        evt.setState("ACTIVE");
        evt.setStartUserId(Context.getCommandContext().getAuthenticatedUserId());
        if (this.isHistoryRemovalTimeStrategyStart()) {
            if (this.isRootProcessInstance(evt)) {
                Date removalTime = this.calculateRemovalTime(evt);
                evt.setRemovalTime(removalTime);
            } else {
                this.provideRemovalTime(evt);
            }
        }
        return evt;
    }

    @Override
    public HistoryEvent createProcessInstanceUpdateEvt(DelegateExecution execution) {
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        HistoricProcessInstanceEventEntity evt = this.loadProcessInstanceEventEntity(executionEntity);
        this.initProcessInstanceEvent(evt, executionEntity, HistoryEventTypes.PROCESS_INSTANCE_UPDATE);
        if (executionEntity.isSuspended()) {
            evt.setState("SUSPENDED");
        } else {
            evt.setState("ACTIVE");
        }
        return evt;
    }

    @Override
    public HistoryEvent createProcessInstanceMigrateEvt(DelegateExecution execution) {
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        HistoricProcessInstanceEventEntity evt = this.newProcessInstanceEventEntity(executionEntity);
        this.initProcessInstanceEvent(evt, executionEntity, HistoryEventTypes.PROCESS_INSTANCE_MIGRATE);
        if (executionEntity.isSuspended()) {
            evt.setState("SUSPENDED");
        } else {
            evt.setState("ACTIVE");
        }
        return evt;
    }

    @Override
    public HistoryEvent createProcessInstanceEndEvt(DelegateExecution execution) {
        Date removalTime;
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        HistoricProcessInstanceEventEntity evt = this.loadProcessInstanceEventEntity(executionEntity);
        this.initProcessInstanceEvent(evt, executionEntity, HistoryEventTypes.PROCESS_INSTANCE_END);
        this.determineEndState(executionEntity, evt);
        evt.setEndActivityId(executionEntity.getActivityId());
        evt.setEndTime(ClockUtil.getCurrentTime());
        if (evt.getStartTime() != null) {
            evt.setDurationInMillis(evt.getEndTime().getTime() - evt.getStartTime().getTime());
        }
        if (this.isRootProcessInstance(evt) && this.isHistoryRemovalTimeStrategyEnd() && (removalTime = this.calculateRemovalTime(evt)) != null) {
            this.addRemovalTimeToHistoricProcessInstances(evt.getRootProcessInstanceId(), removalTime);
            if (this.isDmnEnabled()) {
                this.addRemovalTimeToHistoricDecisions(evt.getRootProcessInstanceId(), removalTime);
            }
        }
        if (executionEntity.getDeleteReason() != null) {
            evt.setDeleteReason(executionEntity.getDeleteReason());
        }
        return evt;
    }

    protected void addRemovalTimeToHistoricDecisions(String rootProcessInstanceId, Date removalTime) {
        Context.getCommandContext().getHistoricDecisionInstanceManager().addRemovalTimeToDecisionsByRootProcessInstanceId(rootProcessInstanceId, removalTime);
    }

    protected void addRemovalTimeToHistoricProcessInstances(String rootProcessInstanceId, Date removalTime) {
        Context.getCommandContext().getHistoricProcessInstanceManager().addRemovalTimeToProcessInstancesByRootProcessInstanceId(rootProcessInstanceId, removalTime);
    }

    protected boolean isDmnEnabled() {
        return Context.getCommandContext().getProcessEngineConfiguration().isDmnEnabled();
    }

    protected void determineEndState(ExecutionEntity executionEntity, HistoricProcessInstanceEventEntity evt) {
        if (executionEntity.getActivity() != null) {
            evt.setState("COMPLETED");
        } else if (executionEntity.isExternallyTerminated()) {
            evt.setState("EXTERNALLY_TERMINATED");
        } else if (!executionEntity.isExternallyTerminated()) {
            evt.setState("INTERNALLY_TERMINATED");
        }
    }

    @Override
    public HistoryEvent createActivityInstanceStartEvt(DelegateExecution execution) {
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        HistoricActivityInstanceEventEntity evt = this.newActivityInstanceEventEntity(executionEntity);
        this.initActivityInstanceEvent(evt, executionEntity, (HistoryEventType)HistoryEventTypes.ACTIVITY_INSTANCE_START);
        this.initSequenceCounter(executionEntity, (HistoryEvent)evt);
        evt.setStartTime(ClockUtil.getCurrentTime());
        return evt;
    }

    @Override
    public HistoryEvent createActivityInstanceUpdateEvt(DelegateExecution execution) {
        return this.createActivityInstanceUpdateEvt(execution, null);
    }

    @Override
    public HistoryEvent createActivityInstanceUpdateEvt(DelegateExecution execution, DelegateTask task) {
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        HistoricActivityInstanceEventEntity evt = this.loadActivityInstanceEventEntity(executionEntity);
        this.initActivityInstanceEvent(evt, executionEntity, (HistoryEventType)HistoryEventTypes.ACTIVITY_INSTANCE_UPDATE);
        if (task != null) {
            evt.setTaskId(task.getId());
            evt.setTaskAssignee(task.getAssignee());
        }
        return evt;
    }

    @Override
    public HistoryEvent createActivityInstanceMigrateEvt(MigratingActivityInstance actInstance) {
        HistoricActivityInstanceEventEntity evt = this.loadActivityInstanceEventEntity(actInstance.resolveRepresentativeExecution());
        this.initActivityInstanceEvent(evt, actInstance, (HistoryEventType)HistoryEventTypes.ACTIVITY_INSTANCE_MIGRATE);
        return evt;
    }

    @Override
    public HistoryEvent createActivityInstanceEndEvt(DelegateExecution execution) {
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        HistoricActivityInstanceEventEntity evt = this.loadActivityInstanceEventEntity(executionEntity);
        evt.setActivityInstanceState(executionEntity.getActivityInstanceState());
        this.initActivityInstanceEvent(evt, (ExecutionEntity)execution, (HistoryEventType)HistoryEventTypes.ACTIVITY_INSTANCE_END);
        evt.setEndTime(ClockUtil.getCurrentTime());
        if (evt.getStartTime() != null) {
            evt.setDurationInMillis(evt.getEndTime().getTime() - evt.getStartTime().getTime());
        }
        return evt;
    }

    @Override
    public HistoryEvent createTaskInstanceCreateEvt(DelegateTask task) {
        HistoricTaskInstanceEventEntity evt = this.newTaskInstanceEventEntity(task);
        this.initTaskInstanceEvent(evt, (TaskEntity)task, HistoryEventTypes.TASK_INSTANCE_CREATE);
        evt.setStartTime(ClockUtil.getCurrentTime());
        return evt;
    }

    @Override
    public HistoryEvent createTaskInstanceUpdateEvt(DelegateTask task) {
        HistoricTaskInstanceEventEntity evt = this.loadTaskInstanceEvent(task);
        this.initTaskInstanceEvent(evt, (TaskEntity)task, HistoryEventTypes.TASK_INSTANCE_UPDATE);
        return evt;
    }

    @Override
    public HistoryEvent createTaskInstanceMigrateEvt(DelegateTask task) {
        HistoricTaskInstanceEventEntity evt = this.loadTaskInstanceEvent(task);
        this.initTaskInstanceEvent(evt, (TaskEntity)task, HistoryEventTypes.TASK_INSTANCE_MIGRATE);
        return evt;
    }

    @Override
    public HistoryEvent createTaskInstanceCompleteEvt(DelegateTask task, String deleteReason) {
        HistoricTaskInstanceEventEntity evt = this.loadTaskInstanceEvent(task);
        this.initTaskInstanceEvent(evt, (TaskEntity)task, HistoryEventTypes.TASK_INSTANCE_COMPLETE);
        evt.setEndTime(ClockUtil.getCurrentTime());
        if (evt.getStartTime() != null) {
            evt.setDurationInMillis(evt.getEndTime().getTime() - evt.getStartTime().getTime());
        }
        evt.setDeleteReason(deleteReason);
        return evt;
    }

    @Override
    public List<HistoryEvent> createUserOperationLogEvents(UserOperationLogContext context) {
        ArrayList<HistoryEvent> historyEvents = new ArrayList<HistoryEvent>();
        String operationId = Context.getCommandContext().getOperationId();
        context.setOperationId(operationId);
        for (UserOperationLogContextEntry entry : context.getEntries()) {
            for (PropertyChange propertyChange : entry.getPropertyChanges()) {
                UserOperationLogEntryEventEntity evt = new UserOperationLogEntryEventEntity();
                this.initUserOperationLogEvent(evt, context, entry, propertyChange);
                historyEvents.add(evt);
            }
        }
        return historyEvents;
    }

    @Override
    public HistoryEvent createHistoricVariableCreateEvt(VariableInstanceEntity variableInstance, VariableScope sourceVariableScope) {
        return this.createHistoricVariableEvent(variableInstance, sourceVariableScope, HistoryEventTypes.VARIABLE_INSTANCE_CREATE);
    }

    @Override
    public HistoryEvent createHistoricVariableDeleteEvt(VariableInstanceEntity variableInstance, VariableScope sourceVariableScope) {
        return this.createHistoricVariableEvent(variableInstance, sourceVariableScope, HistoryEventTypes.VARIABLE_INSTANCE_DELETE);
    }

    @Override
    public HistoryEvent createHistoricVariableUpdateEvt(VariableInstanceEntity variableInstance, VariableScope sourceVariableScope) {
        return this.createHistoricVariableEvent(variableInstance, sourceVariableScope, HistoryEventTypes.VARIABLE_INSTANCE_UPDATE);
    }

    @Override
    public HistoryEvent createHistoricVariableMigrateEvt(VariableInstanceEntity variableInstance) {
        return this.createHistoricVariableEvent(variableInstance, null, HistoryEventTypes.VARIABLE_INSTANCE_MIGRATE);
    }

    @Override
    public HistoryEvent createFormPropertyUpdateEvt(ExecutionEntity execution, String propertyId, String propertyValue, String taskId) {
        ProcessDefinitionEntity definition;
        IdGenerator idGenerator = Context.getProcessEngineConfiguration().getIdGenerator();
        HistoricFormPropertyEventEntity historicFormPropertyEntity = this.newHistoricFormPropertyEvent();
        historicFormPropertyEntity.setId(idGenerator.getNextId());
        historicFormPropertyEntity.setEventType(HistoryEventTypes.FORM_PROPERTY_UPDATE.getEventName());
        historicFormPropertyEntity.setTimestamp(ClockUtil.getCurrentTime());
        historicFormPropertyEntity.setExecutionId(execution.getId());
        historicFormPropertyEntity.setProcessDefinitionId(execution.getProcessDefinitionId());
        historicFormPropertyEntity.setProcessInstanceId(execution.getProcessInstanceId());
        historicFormPropertyEntity.setPropertyId(propertyId);
        historicFormPropertyEntity.setPropertyValue(propertyValue);
        historicFormPropertyEntity.setTaskId(taskId);
        historicFormPropertyEntity.setTenantId(execution.getTenantId());
        historicFormPropertyEntity.setUserOperationId(Context.getCommandContext().getOperationId());
        historicFormPropertyEntity.setRootProcessInstanceId(execution.getRootProcessInstanceId());
        if (this.isHistoryRemovalTimeStrategyStart()) {
            this.provideRemovalTime(historicFormPropertyEntity);
        }
        if ((definition = execution.getProcessDefinition()) != null) {
            historicFormPropertyEntity.setProcessDefinitionKey(definition.getKey());
        }
        this.initSequenceCounter(execution, (HistoryEvent)historicFormPropertyEntity);
        if (execution.isProcessInstanceStarting()) {
            historicFormPropertyEntity.setActivityInstanceId(execution.getProcessInstanceId());
        } else {
            historicFormPropertyEntity.setActivityInstanceId(execution.getActivityInstanceId());
        }
        return historicFormPropertyEntity;
    }

    @Override
    public HistoryEvent createHistoricIncidentCreateEvt(Incident incident) {
        return this.createHistoricIncidentEvt(incident, HistoryEventTypes.INCIDENT_CREATE);
    }

    @Override
    public HistoryEvent createHistoricIncidentUpdateEvt(Incident incident) {
        return this.createHistoricIncidentEvt(incident, HistoryEventTypes.INCIDENT_UPDATE);
    }

    @Override
    public HistoryEvent createHistoricIncidentResolveEvt(Incident incident) {
        return this.createHistoricIncidentEvt(incident, HistoryEventTypes.INCIDENT_RESOLVE);
    }

    @Override
    public HistoryEvent createHistoricIncidentDeleteEvt(Incident incident) {
        return this.createHistoricIncidentEvt(incident, HistoryEventTypes.INCIDENT_DELETE);
    }

    @Override
    public HistoryEvent createHistoricIncidentMigrateEvt(Incident incident) {
        return this.createHistoricIncidentEvt(incident, HistoryEventTypes.INCIDENT_MIGRATE);
    }

    protected HistoryEvent createHistoricIncidentEvt(Incident incident, HistoryEventTypes eventType) {
        HistoricIncidentEventEntity evt = this.loadIncidentEvent(incident);
        this.initHistoricIncidentEvent(evt, incident, eventType);
        if (HistoryEventTypes.INCIDENT_RESOLVE.equals(eventType) || HistoryEventTypes.INCIDENT_DELETE.equals(eventType)) {
            evt.setEndTime(ClockUtil.getCurrentTime());
        }
        return evt;
    }

    @Override
    public HistoryEvent createHistoricIdentityLinkAddEvent(IdentityLink identityLink) {
        return this.createHistoricIdentityLinkEvt(identityLink, HistoryEventTypes.IDENTITY_LINK_ADD);
    }

    @Override
    public HistoryEvent createHistoricIdentityLinkDeleteEvent(IdentityLink identityLink) {
        return this.createHistoricIdentityLinkEvt(identityLink, HistoryEventTypes.IDENTITY_LINK_DELETE);
    }

    protected HistoryEvent createHistoricIdentityLinkEvt(IdentityLink identityLink, HistoryEventTypes eventType) {
        HistoricIdentityLinkLogEventEntity evt = this.newIdentityLinkEventEntity();
        this.initHistoricIdentityLinkEvent(evt, identityLink, eventType);
        return evt;
    }

    protected HistoricIdentityLinkLogEventEntity newIdentityLinkEventEntity() {
        return new HistoricIdentityLinkLogEventEntity();
    }

    protected void initHistoricIdentityLinkEvent(HistoricIdentityLinkLogEventEntity evt, IdentityLink identityLink, HistoryEventType eventType) {
        if (identityLink.getTaskId() != null) {
            ExecutionEntity execution;
            TaskEntity task = Context.getCommandContext().getTaskManager().findTaskById(identityLink.getTaskId());
            evt.setProcessDefinitionId(task.getProcessDefinitionId());
            if (task.getProcessDefinition() != null) {
                evt.setProcessDefinitionKey(task.getProcessDefinition().getKey());
            }
            if ((execution = task.getExecution()) != null) {
                evt.setRootProcessInstanceId(execution.getRootProcessInstanceId());
                if (this.isHistoryRemovalTimeStrategyStart()) {
                    this.provideRemovalTime(evt);
                }
            }
        }
        if (identityLink.getProcessDefId() != null) {
            evt.setProcessDefinitionId(identityLink.getProcessDefId());
            ProcessDefinitionEntity definition = Context.getProcessEngineConfiguration().getDeploymentCache().findProcessDefinitionFromCache(identityLink.getProcessDefId());
            evt.setProcessDefinitionKey(definition.getKey());
        }
        evt.setTime(ClockUtil.getCurrentTime());
        evt.setType(identityLink.getType());
        evt.setUserId(identityLink.getUserId());
        evt.setGroupId(identityLink.getGroupId());
        evt.setTaskId(identityLink.getTaskId());
        evt.setTenantId(identityLink.getTenantId());
        String operationType = "add";
        if (eventType.getEventName().equals(HistoryEventTypes.IDENTITY_LINK_DELETE.getEventName())) {
            operationType = "delete";
        }
        evt.setOperationType(operationType);
        evt.setEventType(eventType.getEventName());
        evt.setAssignerId(Context.getCommandContext().getAuthenticatedUserId());
    }

    @Override
    public HistoryEvent createBatchStartEvent(Batch batch) {
        HistoryEvent historicBatch = this.createBatchEvent((BatchEntity)batch, HistoryEventTypes.BATCH_START);
        if (this.isHistoryRemovalTimeStrategyStart()) {
            this.provideRemovalTime((HistoricBatchEntity)historicBatch);
        }
        return historicBatch;
    }

    @Override
    public HistoryEvent createBatchEndEvent(Batch batch) {
        HistoryEvent historicBatch = this.createBatchEvent((BatchEntity)batch, HistoryEventTypes.BATCH_END);
        if (this.isHistoryRemovalTimeStrategyEnd()) {
            this.provideRemovalTime((HistoricBatchEntity)historicBatch);
            this.addRemovalTimeToHistoricJobLog((HistoricBatchEntity)historicBatch);
            this.addRemovalTimeToHistoricIncidents((HistoricBatchEntity)historicBatch);
        }
        return historicBatch;
    }

    @Override
    public HistoryEvent createBatchUpdateEvent(Batch batch) {
        return this.createBatchEvent((BatchEntity)batch, HistoryEventTypes.BATCH_UPDATE);
    }

    protected HistoryEvent createBatchEvent(BatchEntity batch, HistoryEventTypes eventType) {
        HistoricBatchEntity event = this.loadBatchEntity(batch);
        event.setId(batch.getId());
        event.setType(batch.getType());
        event.setTotalJobs(batch.getTotalJobs());
        event.setBatchJobsPerSeed(batch.getBatchJobsPerSeed());
        event.setInvocationsPerBatchJob(batch.getInvocationsPerBatchJob());
        event.setSeedJobDefinitionId(batch.getSeedJobDefinitionId());
        event.setMonitorJobDefinitionId(batch.getMonitorJobDefinitionId());
        event.setBatchJobDefinitionId(batch.getBatchJobDefinitionId());
        event.setTenantId(batch.getTenantId());
        event.setEventType(eventType.getEventName());
        if (HistoryEventTypes.BATCH_START.equals(eventType)) {
            event.setStartTime(batch.getStartTime());
            event.setCreateUserId(Context.getCommandContext().getAuthenticatedUserId());
        }
        if (HistoryEventTypes.BATCH_END.equals(eventType)) {
            event.setEndTime(ClockUtil.getCurrentTime());
        }
        if (HistoryEventTypes.BATCH_UPDATE.equals(eventType)) {
            event.setExecutionStartTime(batch.getExecutionStartTime());
        }
        return event;
    }

    @Override
    public HistoryEvent createHistoricJobLogCreateEvt(Job job) {
        return this.createHistoricJobLogEvt(job, HistoryEventTypes.JOB_CREATE);
    }

    @Override
    public HistoryEvent createHistoricJobLogFailedEvt(Job job, Throwable exception) {
        HistoricJobLogEventEntity event = (HistoricJobLogEventEntity)this.createHistoricJobLogEvt(job, HistoryEventTypes.JOB_FAIL);
        if (exception != null) {
            event.setJobExceptionMessage(exception.getMessage());
            String exceptionStacktrace = ExceptionUtil.getExceptionStacktrace(exception);
            byte[] exceptionBytes = StringUtil.toByteArray(exceptionStacktrace);
            ByteArrayEntity byteArray = ExceptionUtil.createJobExceptionByteArray(exceptionBytes, ResourceTypes.HISTORY);
            byteArray.setRootProcessInstanceId(event.getRootProcessInstanceId());
            byteArray.setRemovalTime(event.getRemovalTime());
            event.setExceptionByteArrayId(byteArray.getId());
        }
        return event;
    }

    @Override
    public HistoryEvent createHistoricJobLogSuccessfulEvt(Job job) {
        return this.createHistoricJobLogEvt(job, HistoryEventTypes.JOB_SUCCESS);
    }

    @Override
    public HistoryEvent createHistoricJobLogDeleteEvt(Job job) {
        return this.createHistoricJobLogEvt(job, HistoryEventTypes.JOB_DELETE);
    }

    protected HistoryEvent createHistoricJobLogEvt(Job job, HistoryEventType eventType) {
        HistoricJobLogEventEntity event = this.newHistoricJobLogEntity(job);
        this.initHistoricJobLogEvent(event, job, eventType);
        return event;
    }

    protected void initHistoricJobLogEvent(HistoricJobLogEventEntity evt, Job job, HistoryEventType eventType) {
        JobDefinition jobDefinition;
        String timeToLive;
        Date currentTime = ClockUtil.getCurrentTime();
        evt.setTimestamp(currentTime);
        JobEntity jobEntity = (JobEntity)job;
        evt.setJobId(jobEntity.getId());
        evt.setJobDueDate(jobEntity.getDuedate());
        evt.setJobRetries(jobEntity.getRetries());
        evt.setJobPriority(jobEntity.getPriority());
        String hostName = Context.getCommandContext().getProcessEngineConfiguration().getHostname();
        evt.setHostname(hostName);
        if ("history-cleanup".equals(jobEntity.getJobHandlerType()) && (timeToLive = Context.getProcessEngineConfiguration().getHistoryCleanupJobLogTimeToLive()) != null) {
            try {
                Integer timeToLiveDays = ParseUtil.parseHistoryTimeToLive(timeToLive);
                Date removalTime = DefaultHistoryRemovalTimeProvider.determineRemovalTime(currentTime, timeToLiveDays);
                evt.setRemovalTime(removalTime);
            }
            catch (ProcessEngineException e) {
                ProcessEngineException wrappedException = LOG.invalidPropertyValue("historyCleanupJobLogTimeToLive", timeToLive, e);
                LOG.invalidPropertyValue(wrappedException);
            }
        }
        if ((jobDefinition = jobEntity.getJobDefinition()) != null) {
            HistoricBatchEntity historicBatch;
            evt.setJobDefinitionId(jobDefinition.getId());
            evt.setJobDefinitionType(jobDefinition.getJobType());
            evt.setJobDefinitionConfiguration(jobDefinition.getJobConfiguration());
            String historicBatchId = jobDefinition.getJobConfiguration();
            if (historicBatchId != null && this.isHistoryRemovalTimeStrategyStart() && (historicBatch = this.getHistoricBatchById(historicBatchId)) != null) {
                evt.setRemovalTime(historicBatch.getRemovalTime());
            }
        } else {
            evt.setJobDefinitionType(jobEntity.getJobHandlerType());
        }
        evt.setActivityId(jobEntity.getActivityId());
        evt.setFailedActivityId(jobEntity.getFailedActivityId());
        evt.setExecutionId(jobEntity.getExecutionId());
        evt.setProcessInstanceId(jobEntity.getProcessInstanceId());
        evt.setProcessDefinitionId(jobEntity.getProcessDefinitionId());
        evt.setProcessDefinitionKey(jobEntity.getProcessDefinitionKey());
        evt.setDeploymentId(jobEntity.getDeploymentId());
        evt.setTenantId(jobEntity.getTenantId());
        ExecutionEntity execution = jobEntity.getExecution();
        if (execution != null) {
            evt.setRootProcessInstanceId(execution.getRootProcessInstanceId());
            if (this.isHistoryRemovalTimeStrategyStart()) {
                this.provideRemovalTime(evt);
            }
        }
        this.initSequenceCounter(jobEntity, (HistoryEvent)evt);
        JobState state = null;
        if (HistoryEventTypes.JOB_CREATE.equals(eventType)) {
            state = JobState.CREATED;
        } else if (HistoryEventTypes.JOB_FAIL.equals(eventType)) {
            state = JobState.FAILED;
        } else if (HistoryEventTypes.JOB_SUCCESS.equals(eventType)) {
            state = JobState.SUCCESSFUL;
        } else if (HistoryEventTypes.JOB_DELETE.equals(eventType)) {
            state = JobState.DELETED;
        }
        evt.setState(state.getStateCode());
    }

    @Override
    public HistoryEvent createHistoricExternalTaskLogCreatedEvt(ExternalTask task) {
        return this.initHistoricExternalTaskLog((ExternalTaskEntity)task, ExternalTaskState.CREATED);
    }

    @Override
    public HistoryEvent createHistoricExternalTaskLogFailedEvt(ExternalTask task) {
        HistoricExternalTaskLogEntity event = this.initHistoricExternalTaskLog((ExternalTaskEntity)task, ExternalTaskState.FAILED);
        event.setErrorMessage(task.getErrorMessage());
        String errorDetails = ((ExternalTaskEntity)task).getErrorDetails();
        if (errorDetails != null) {
            event.setErrorDetails(errorDetails);
        }
        return event;
    }

    @Override
    public HistoryEvent createHistoricExternalTaskLogSuccessfulEvt(ExternalTask task) {
        return this.initHistoricExternalTaskLog((ExternalTaskEntity)task, ExternalTaskState.SUCCESSFUL);
    }

    @Override
    public HistoryEvent createHistoricExternalTaskLogDeletedEvt(ExternalTask task) {
        return this.initHistoricExternalTaskLog((ExternalTaskEntity)task, ExternalTaskState.DELETED);
    }

    protected HistoricExternalTaskLogEntity initHistoricExternalTaskLog(ExternalTaskEntity entity, ExternalTaskState state) {
        HistoricExternalTaskLogEntity event = new HistoricExternalTaskLogEntity();
        event.setTimestamp(this.getTimestamp(entity, state));
        event.setExternalTaskId(entity.getId());
        event.setTopicName(entity.getTopicName());
        event.setWorkerId(entity.getWorkerId());
        event.setPriority(entity.getPriority());
        event.setRetries(entity.getRetries());
        event.setActivityId(entity.getActivityId());
        event.setActivityInstanceId(entity.getActivityInstanceId());
        event.setExecutionId(entity.getExecutionId());
        event.setProcessInstanceId(entity.getProcessInstanceId());
        event.setProcessDefinitionId(entity.getProcessDefinitionId());
        event.setProcessDefinitionKey(entity.getProcessDefinitionKey());
        event.setTenantId(entity.getTenantId());
        event.setState(state.getStateCode());
        ExecutionEntity execution = entity.getExecution();
        if (execution != null) {
            event.setRootProcessInstanceId(execution.getRootProcessInstanceId());
            if (this.isHistoryRemovalTimeStrategyStart()) {
                this.provideRemovalTime(event);
            }
        }
        return event;
    }

    protected Date getTimestamp(ExternalTaskEntity entity, ExternalTaskState state) {
        return state == ExternalTaskState.CREATED ? entity.getCreateTime() : ClockUtil.getCurrentTime();
    }

    protected boolean isRootProcessInstance(HistoricProcessInstanceEventEntity evt) {
        return evt.getProcessInstanceId().equals(evt.getRootProcessInstanceId());
    }

    protected boolean isHistoryRemovalTimeStrategyStart() {
        return "start".equals(this.getHistoryRemovalTimeStrategy());
    }

    protected boolean isHistoryRemovalTimeStrategyEnd() {
        return "end".equals(this.getHistoryRemovalTimeStrategy());
    }

    protected String getHistoryRemovalTimeStrategy() {
        return Context.getProcessEngineConfiguration().getHistoryRemovalTimeStrategy();
    }

    protected Date calculateRemovalTime(HistoryEvent historyEvent) {
        String processDefinitionId = historyEvent.getProcessDefinitionId();
        ProcessDefinition processDefinition = this.findProcessDefinitionById(processDefinitionId);
        return Context.getProcessEngineConfiguration().getHistoryRemovalTimeProvider().calculateRemovalTime((HistoricProcessInstanceEventEntity)historyEvent, processDefinition);
    }

    protected Date calculateRemovalTime(HistoricBatchEntity historicBatch) {
        return Context.getProcessEngineConfiguration().getHistoryRemovalTimeProvider().calculateRemovalTime(historicBatch);
    }

    protected void provideRemovalTime(HistoricBatchEntity historicBatch) {
        Date removalTime = this.calculateRemovalTime(historicBatch);
        if (removalTime != null) {
            historicBatch.setRemovalTime(removalTime);
        }
    }

    protected void provideRemovalTime(HistoryEvent historyEvent) {
        HistoricProcessInstanceEventEntity historicRootProcessInstance;
        String rootProcessInstanceId = historyEvent.getRootProcessInstanceId();
        if (rootProcessInstanceId != null && (historicRootProcessInstance = this.getHistoricRootProcessInstance(rootProcessInstanceId)) != null) {
            Date removalTime = historicRootProcessInstance.getRemovalTime();
            historyEvent.setRemovalTime(removalTime);
        }
    }

    protected HistoricProcessInstanceEventEntity getHistoricRootProcessInstance(String rootProcessInstanceId) {
        return Context.getCommandContext().getDbEntityManager().selectById(HistoricProcessInstanceEventEntity.class, rootProcessInstanceId);
    }

    protected ProcessDefinition findProcessDefinitionById(String processDefinitionId) {
        return Context.getCommandContext().getProcessEngineConfiguration().getDeploymentCache().findDeployedProcessDefinitionById(processDefinitionId);
    }

    protected HistoricBatchEntity getHistoricBatchById(String batchId) {
        return Context.getCommandContext().getHistoricBatchManager().findHistoricBatchById(batchId);
    }

    protected HistoricBatchEntity getHistoricBatchByJobId(String jobId) {
        return Context.getCommandContext().getHistoricBatchManager().findHistoricBatchByJobId(jobId);
    }

    protected void addRemovalTimeToHistoricJobLog(HistoricBatchEntity historicBatch) {
        Date removalTime = historicBatch.getRemovalTime();
        if (removalTime != null) {
            Context.getCommandContext().getHistoricJobLogManager().addRemovalTimeToJobLogByBatchId(historicBatch.getId(), removalTime);
        }
    }

    protected void addRemovalTimeToHistoricIncidents(HistoricBatchEntity historicBatch) {
        Date removalTime = historicBatch.getRemovalTime();
        if (removalTime != null) {
            Context.getCommandContext().getHistoricIncidentManager().addRemovalTimeToHistoricIncidentsByBatchId(historicBatch.getId(), removalTime);
        }
    }

    protected void initSequenceCounter(ExecutionEntity execution, HistoryEvent event) {
        this.initSequenceCounter(execution.getSequenceCounter(), event);
    }

    protected void initSequenceCounter(VariableInstanceEntity variable, HistoryEvent event) {
        this.initSequenceCounter(variable.getSequenceCounter(), event);
    }

    protected void initSequenceCounter(JobEntity job, HistoryEvent event) {
        this.initSequenceCounter(job.getSequenceCounter(), event);
    }

    protected void initSequenceCounter(long sequenceCounter, HistoryEvent event) {
        event.setSequenceCounter(sequenceCounter);
    }
}

