/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.dmn.deployer;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.camunda.bpm.dmn.engine.impl.spi.transform.DmnTransformer;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.AbstractDefinitionDeployer;
import org.camunda.bpm.engine.impl.core.model.Properties;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionEntity;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionManager;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentCache;
import org.camunda.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ResourceEntity;

public class DmnDeployer
extends AbstractDefinitionDeployer<DecisionDefinitionEntity> {
    public static final String[] DMN_RESOURCE_SUFFIXES = new String[]{"dmn11.xml", "dmn"};
    protected DmnTransformer transformer;

    @Override
    protected String[] getResourcesSuffixes() {
        return DMN_RESOURCE_SUFFIXES;
    }

    @Override
    protected List<DecisionDefinitionEntity> transformDefinitions(DeploymentEntity deployment, ResourceEntity resource, Properties properties) {
        byte[] bytes = resource.getBytes();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        try {
            return this.transformer.createTransform().modelInstance((InputStream)inputStream).transformDecisions();
        }
        catch (Exception e) {
            throw new ProcessEngineException("Unable to transform DMN resource '" + resource.getName() + "'", e);
        }
    }

    @Override
    protected DecisionDefinitionEntity findDefinitionByDeploymentAndKey(String deploymentId, String definitionKey) {
        return this.getDecisionDefinitionManager().findDecisionDefinitionByDeploymentAndKey(deploymentId, definitionKey);
    }

    @Override
    protected DecisionDefinitionEntity findLatestDefinitionByKeyAndTenantId(String definitionKey, String tenantId) {
        return this.getDecisionDefinitionManager().findLatestDecisionDefinitionByKeyAndTenantId(definitionKey, tenantId);
    }

    @Override
    protected void persistDefinition(DecisionDefinitionEntity definition) {
        this.getDecisionDefinitionManager().insertDecisionDefinition(definition);
    }

    @Override
    protected void addDefinitionToDeploymentCache(DeploymentCache deploymentCache, DecisionDefinitionEntity definition) {
        deploymentCache.addDecisionDefinition(definition);
    }

    protected DecisionDefinitionManager getDecisionDefinitionManager() {
        return this.getCommandContext().getDecisionDefinitionManager();
    }

    public DmnTransformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(DmnTransformer transformer) {
        this.transformer = transformer;
    }
}

