/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.dmn.result;

import org.camunda.bpm.dmn.engine.DmnDecisionRuleResult;
import org.camunda.bpm.dmn.engine.DmnDecisionTableResult;
import org.camunda.bpm.dmn.engine.DmnEngineException;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.dmn.DecisionLogger;
import org.camunda.bpm.engine.impl.dmn.result.DecisionTableResultMapper;
import org.camunda.bpm.engine.variable.Variables;

public class SingleResultDecisionTableResultMapper
implements DecisionTableResultMapper {
    protected static final DecisionLogger LOG = ProcessEngineLogger.DECISION_LOGGER;

    @Override
    public Object mapDecisionTableResult(DmnDecisionTableResult decisionTableResult) {
        try {
            DmnDecisionRuleResult singleResult = decisionTableResult.getSingleResult();
            if (singleResult != null) {
                return singleResult.getEntryMap();
            }
            return Variables.untypedNullValue();
        }
        catch (DmnEngineException e) {
            throw LOG.decisionResultMappingException(decisionTableResult, this, e);
        }
    }

    public String toString() {
        return "SingleResultDecisionTableResultMapper{}";
    }
}

