/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;

public class CompensateEventSubscriptionEntity
extends EventSubscriptionEntity {
    private static final long serialVersionUID = 1L;

    public CompensateEventSubscriptionEntity() {
    }

    private CompensateEventSubscriptionEntity(ExecutionEntity executionEntity) {
        super(executionEntity);
        this.eventType = "compensate";
    }

    public static CompensateEventSubscriptionEntity createAndInsert(ExecutionEntity executionEntity, ActivityImpl activity) {
        CompensateEventSubscriptionEntity eventSubscription = new CompensateEventSubscriptionEntity(executionEntity);
        eventSubscription.setActivity(activity);
        eventSubscription.setTenantId(executionEntity.getTenantId());
        eventSubscription.insert();
        return eventSubscription;
    }

    @Override
    protected void processEventSync(Object payload) {
        this.delete();
        super.processEventSync(payload);
    }

    public CompensateEventSubscriptionEntity moveUnder(ExecutionEntity newExecution) {
        this.delete();
        CompensateEventSubscriptionEntity newSubscription = CompensateEventSubscriptionEntity.createAndInsert(newExecution, this.getActivity());
        newSubscription.setConfiguration(this.configuration);
        newSubscription.setCreated(this.created);
        return newSubscription;
    }

    public ExecutionEntity getCompensatingExecution() {
        if (this.configuration != null) {
            return Context.getCommandContext().getExecutionManager().findExecutionById(this.configuration);
        }
        return null;
    }
}

