/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.history.HistoricCaseInstance;
import org.camunda.bpm.engine.impl.HistoricCaseInstanceQueryImpl;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.db.ListQueryParameterObject;
import org.camunda.bpm.engine.impl.history.event.HistoricCaseInstanceEventEntity;
import org.camunda.bpm.engine.impl.persistence.AbstractHistoricManager;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricCaseInstanceEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;

public class HistoricCaseInstanceManager
extends AbstractHistoricManager {
    public HistoricCaseInstanceEntity findHistoricCaseInstance(String caseInstanceId) {
        if (this.isHistoryEnabled()) {
            return this.getDbEntityManager().selectById(HistoricCaseInstanceEntity.class, caseInstanceId);
        }
        return null;
    }

    public HistoricCaseInstanceEventEntity findHistoricCaseInstanceEvent(String eventId) {
        if (this.isHistoryEnabled()) {
            return this.getDbEntityManager().selectById(HistoricCaseInstanceEventEntity.class, eventId);
        }
        return null;
    }

    public void deleteHistoricCaseInstanceByCaseDefinitionId(String caseDefinitionId) {
        if (this.isHistoryEnabled()) {
            List historicCaseInstanceIds = this.getDbEntityManager().selectList("selectHistoricCaseInstanceIdsByCaseDefinitionId", caseDefinitionId);
            for (String historicCaseInstanceId : historicCaseInstanceIds) {
                this.deleteHistoricCaseInstanceById(historicCaseInstanceId);
            }
        }
    }

    public void deleteHistoricCaseInstanceById(String historicCaseInstanceId) {
        if (this.isHistoryEnabled()) {
            this.getHistoricDetailManager().deleteHistoricDetailsByCaseInstanceId(historicCaseInstanceId);
            this.getHistoricVariableInstanceManager().deleteHistoricVariableInstanceByCaseInstanceId(historicCaseInstanceId);
            this.getHistoricCaseActivityInstanceManager().deleteHistoricCaseActivityInstancesByCaseInstanceId(historicCaseInstanceId);
            this.getHistoricTaskInstanceManager().deleteHistoricTaskInstancesByCaseInstanceId(historicCaseInstanceId);
            this.getDbEntityManager().delete(HistoricCaseInstanceEntity.class, "deleteHistoricCaseInstance", historicCaseInstanceId);
        }
    }

    public void deleteHistoricCaseInstancesByIds(List<String> historicCaseInstanceIds) {
        if (this.isHistoryEnabled()) {
            this.getHistoricDetailManager().deleteHistoricDetailsByCaseInstanceIds(historicCaseInstanceIds);
            this.getHistoricVariableInstanceManager().deleteHistoricVariableInstancesByCaseInstanceIds(historicCaseInstanceIds);
            this.getHistoricCaseActivityInstanceManager().deleteHistoricCaseActivityInstancesByCaseInstanceIds(historicCaseInstanceIds);
            this.getHistoricTaskInstanceManager().deleteHistoricTaskInstancesByCaseInstanceIds(historicCaseInstanceIds);
            this.getDbEntityManager().delete(HistoricCaseInstanceEntity.class, "deleteHistoricCaseInstancesByIds", historicCaseInstanceIds);
        }
    }

    public long findHistoricCaseInstanceCountByQueryCriteria(HistoricCaseInstanceQueryImpl historicCaseInstanceQuery) {
        if (this.isHistoryEnabled()) {
            this.configureHistoricCaseInstanceQuery(historicCaseInstanceQuery);
            return (Long)this.getDbEntityManager().selectOne("selectHistoricCaseInstanceCountByQueryCriteria", historicCaseInstanceQuery);
        }
        return 0L;
    }

    public List<HistoricCaseInstance> findHistoricCaseInstancesByQueryCriteria(HistoricCaseInstanceQueryImpl historicCaseInstanceQuery, Page page) {
        if (this.isHistoryEnabled()) {
            this.configureHistoricCaseInstanceQuery(historicCaseInstanceQuery);
            return this.getDbEntityManager().selectList("selectHistoricCaseInstancesByQueryCriteria", historicCaseInstanceQuery, page);
        }
        return Collections.EMPTY_LIST;
    }

    public List<HistoricCaseInstance> findHistoricCaseInstancesByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.getDbEntityManager().selectListWithRawParameter("selectHistoricCaseInstanceByNativeQuery", parameterMap, firstResult, maxResults);
    }

    public long findHistoricCaseInstanceCountByNativeQuery(Map<String, Object> parameterMap) {
        return (Long)this.getDbEntityManager().selectOne("selectHistoricCaseInstanceCountByNativeQuery", parameterMap);
    }

    protected void configureHistoricCaseInstanceQuery(HistoricCaseInstanceQueryImpl query) {
        this.getTenantManager().configureQuery(query);
    }

    public List<String> findHistoricCaseInstanceIdsForCleanup(int batchSize) {
        ListQueryParameterObject parameterObject = new ListQueryParameterObject();
        parameterObject.setParameter(ClockUtil.getCurrentTime());
        parameterObject.setFirstResult(0);
        parameterObject.setMaxResults(batchSize);
        return this.getDbEntityManager().selectList("selectHistoricCaseInstanceIdsForCleanup", parameterObject);
    }
}

