/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.tree;

import java.util.Map;
import org.camunda.bpm.engine.impl.pvm.PvmScope;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.camunda.bpm.engine.impl.tree.ActivityExecutionTuple;
import org.camunda.bpm.engine.impl.tree.ReferenceWalker;
import org.camunda.bpm.engine.impl.tree.SingleReferenceWalker;
import org.camunda.bpm.engine.impl.tree.TreeVisitor;

public class ActivityExecutionHierarchyWalker
extends SingleReferenceWalker<ActivityExecutionTuple> {
    private Map<ScopeImpl, PvmExecutionImpl> activityExecutionMapping;

    public ActivityExecutionHierarchyWalker(ActivityExecution execution) {
        super(ActivityExecutionHierarchyWalker.createTupel(execution));
        this.activityExecutionMapping = execution.createActivityExecutionMapping();
    }

    @Override
    protected ActivityExecutionTuple nextElement() {
        PvmScope currentScope = ((ActivityExecutionTuple)this.getCurrentElement()).getScope();
        ScopeImpl flowScope = currentScope.getFlowScope();
        if (flowScope != null) {
            PvmExecutionImpl execution = this.activityExecutionMapping.get(flowScope);
            return new ActivityExecutionTuple(flowScope, execution);
        }
        PvmExecutionImpl currentExecution = this.activityExecutionMapping.get(currentScope);
        PvmExecutionImpl superExecution = currentExecution.getSuperExecution();
        if (superExecution != null) {
            this.activityExecutionMapping = superExecution.createActivityExecutionMapping();
            return ActivityExecutionHierarchyWalker.createTupel(superExecution);
        }
        return null;
    }

    protected static ActivityExecutionTuple createTupel(ActivityExecution execution) {
        PvmScope flowScope = ActivityExecutionHierarchyWalker.getCurrentFlowScope(execution);
        return new ActivityExecutionTuple(flowScope, execution);
    }

    protected static PvmScope getCurrentFlowScope(ActivityExecution execution) {
        ScopeImpl scope = null;
        scope = execution.getTransition() != null ? execution.getTransition().getDestination().getFlowScope() : (ScopeImpl)((Object)execution.getActivity());
        if (scope.isScope()) {
            return scope;
        }
        return scope.getFlowScope();
    }

    public ReferenceWalker<ActivityExecutionTuple> addScopePreVisitor(TreeVisitor<PvmScope> visitor) {
        return this.addPreVisitor(new ScopeVisitorWrapper(visitor));
    }

    public ReferenceWalker<ActivityExecutionTuple> addScopePostVisitor(TreeVisitor<PvmScope> visitor) {
        return this.addPostVisitor(new ScopeVisitorWrapper(visitor));
    }

    public ReferenceWalker<ActivityExecutionTuple> addExecutionPreVisitor(TreeVisitor<ActivityExecution> visitor) {
        return this.addPreVisitor(new ExecutionVisitorWrapper(visitor));
    }

    public ReferenceWalker<ActivityExecutionTuple> addExecutionPostVisitor(TreeVisitor<ActivityExecution> visitor) {
        return this.addPostVisitor(new ExecutionVisitorWrapper(visitor));
    }

    private class ScopeVisitorWrapper
    implements TreeVisitor<ActivityExecutionTuple> {
        private final TreeVisitor<PvmScope> collector;

        public ScopeVisitorWrapper(TreeVisitor<PvmScope> collector) {
            this.collector = collector;
        }

        @Override
        public void visit(ActivityExecutionTuple tupel) {
            this.collector.visit(tupel.getScope());
        }
    }

    private class ExecutionVisitorWrapper
    implements TreeVisitor<ActivityExecutionTuple> {
        private final TreeVisitor<ActivityExecution> collector;

        public ExecutionVisitorWrapper(TreeVisitor<ActivityExecution> collector) {
            this.collector = collector;
        }

        @Override
        public void visit(ActivityExecutionTuple tupel) {
            this.collector.visit(tupel.getExecution());
        }
    }
}

