/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.variable.listener;

import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.CaseVariableListener;
import org.camunda.bpm.engine.delegate.DelegateCaseVariableInstance;
import org.camunda.bpm.engine.delegate.Expression;
import org.camunda.bpm.engine.impl.bpmn.parser.FieldDeclaration;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.util.ClassDelegateUtil;
import org.camunda.bpm.engine.impl.variable.listener.CaseVariableListenerInvocation;

public class DelegateExpressionCaseVariableListener
implements CaseVariableListener {
    protected Expression expression;
    private final List<FieldDeclaration> fieldDeclarations;

    public DelegateExpressionCaseVariableListener(Expression expression, List<FieldDeclaration> fieldDeclarations) {
        this.expression = expression;
        this.fieldDeclarations = fieldDeclarations;
    }

    @Override
    public void notify(DelegateCaseVariableInstance variableInstance) throws Exception {
        Object delegate = this.expression.getValue(variableInstance.getSourceExecution());
        ClassDelegateUtil.applyFieldDeclaration(this.fieldDeclarations, delegate);
        if (!(delegate instanceof CaseVariableListener)) {
            throw new ProcessEngineException("Delegate expression " + this.expression + " did not resolve to an implementation of " + CaseVariableListener.class);
        }
        CaseVariableListener listenerInstance = (CaseVariableListener)delegate;
        Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new CaseVariableListenerInvocation(listenerInstance, variableInstance));
    }

    public String getExpressionText() {
        return this.expression.getExpressionText();
    }

    public List<FieldDeclaration> getFieldDeclarations() {
        return this.fieldDeclarations;
    }
}

