/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.container.impl.deployment.jobexecutor;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.camunda.bpm.container.impl.jmx.services.JmxManagedThreadPool;
import org.camunda.bpm.container.impl.metadata.spi.BpmPlatformXml;
import org.camunda.bpm.container.impl.metadata.spi.JobExecutorXml;
import org.camunda.bpm.container.impl.spi.DeploymentOperation;
import org.camunda.bpm.container.impl.spi.DeploymentOperationStep;
import org.camunda.bpm.container.impl.spi.PlatformServiceContainer;
import org.camunda.bpm.container.impl.spi.ServiceTypes;

public class StartManagedThreadPoolStep
extends DeploymentOperationStep {
    private static final int DEFAULT_CORE_POOL_SIZE = 3;
    private static final int DEFAULT_MAX_POOL_SIZE = 10;
    private static final long DEFAULT_KEEP_ALIVE_TIME_MS = 0L;
    private static final int DEFAULT_QUEUE_SIZE = 3;

    @Override
    public String getName() {
        return "Deploy Job Executor Thread Pool";
    }

    @Override
    public void performOperationStep(DeploymentOperation operationContext) {
        PlatformServiceContainer serviceContainer = operationContext.getServiceContainer();
        JobExecutorXml jobExecutorXml = this.getJobExecutorXml(operationContext);
        int queueSize = this.getQueueSize(jobExecutorXml);
        int corePoolSize = this.getCorePoolSize(jobExecutorXml);
        int maxPoolSize = this.getMaxPoolSize(jobExecutorXml);
        long keepAliveTime = this.getKeepAliveTime(jobExecutorXml);
        ArrayBlockingQueue<Runnable> threadPoolQueue = new ArrayBlockingQueue<Runnable>(queueSize);
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(corePoolSize, maxPoolSize, keepAliveTime, TimeUnit.MILLISECONDS, threadPoolQueue);
        threadPoolExecutor.setRejectedExecutionHandler(new ThreadPoolExecutor.AbortPolicy());
        JmxManagedThreadPool managedThreadPool = new JmxManagedThreadPool(threadPoolQueue, threadPoolExecutor);
        serviceContainer.startService(ServiceTypes.BPM_PLATFORM, "executor-service", managedThreadPool);
    }

    private JobExecutorXml getJobExecutorXml(DeploymentOperation operationContext) {
        BpmPlatformXml bpmPlatformXml = (BpmPlatformXml)operationContext.getAttachment("bpmPlatformXml");
        JobExecutorXml jobExecutorXml = bpmPlatformXml.getJobExecutor();
        return jobExecutorXml;
    }

    private int getQueueSize(JobExecutorXml jobExecutorXml) {
        String queueSize = jobExecutorXml.getProperties().get("queueSize");
        if (queueSize == null) {
            return 3;
        }
        return Integer.parseInt(queueSize);
    }

    private long getKeepAliveTime(JobExecutorXml jobExecutorXml) {
        String keepAliveTime = jobExecutorXml.getProperties().get("keepAliveTime");
        if (keepAliveTime == null) {
            return 0L;
        }
        return Long.parseLong(keepAliveTime);
    }

    private int getMaxPoolSize(JobExecutorXml jobExecutorXml) {
        String maxPoolSize = jobExecutorXml.getProperties().get("maxPoolSize");
        if (maxPoolSize == null) {
            return 10;
        }
        return Integer.parseInt(maxPoolSize);
    }

    private int getCorePoolSize(JobExecutorXml jobExecutorXml) {
        String corePoolSize = jobExecutorXml.getProperties().get("corePoolSize");
        if (corePoolSize == null) {
            return 3;
        }
        return Integer.parseInt(corePoolSize);
    }
}

