/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cmd.CommandLogger;
import org.camunda.bpm.engine.impl.cmd.CorrelateAllMessageCmd;
import org.camunda.bpm.engine.impl.cmd.CorrelateMessageCmd;
import org.camunda.bpm.engine.impl.cmd.CorrelateStartMessageCmd;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.runtime.MessageCorrelationBuilder;
import org.camunda.bpm.engine.runtime.MessageCorrelationResult;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.impl.VariableMapImpl;

public class MessageCorrelationBuilderImpl
implements MessageCorrelationBuilder {
    private static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;
    protected CommandExecutor commandExecutor;
    protected CommandContext commandContext;
    protected boolean isExclusiveCorrelation = false;
    protected String messageName;
    protected String businessKey;
    protected String processInstanceId;
    protected String processDefinitionId;
    protected VariableMap correlationProcessInstanceVariables;
    protected VariableMap correlationLocalVariables;
    protected VariableMap payloadProcessInstanceVariables;
    protected String tenantId = null;
    protected boolean isTenantIdSet = false;

    public MessageCorrelationBuilderImpl(CommandExecutor commandExecutor, String messageName) {
        this(messageName);
        EnsureUtil.ensureNotNull("commandExecutor", (Object)commandExecutor);
        this.commandExecutor = commandExecutor;
    }

    public MessageCorrelationBuilderImpl(CommandContext commandContext, String messageName) {
        this(messageName);
        EnsureUtil.ensureNotNull("commandContext", (Object)commandContext);
        this.commandContext = commandContext;
    }

    private MessageCorrelationBuilderImpl(String messageName) {
        this.messageName = messageName;
    }

    @Override
    public MessageCorrelationBuilder processInstanceBusinessKey(String businessKey) {
        EnsureUtil.ensureNotNull("businessKey", (Object)businessKey);
        this.businessKey = businessKey;
        return this;
    }

    @Override
    public MessageCorrelationBuilder processInstanceVariableEquals(String variableName, Object variableValue) {
        EnsureUtil.ensureNotNull("variableName", (Object)variableName);
        this.ensureCorrelationProcessInstanceVariablesInitialized();
        this.correlationProcessInstanceVariables.put((Object)variableName, variableValue);
        return this;
    }

    @Override
    public MessageCorrelationBuilder processInstanceVariablesEqual(Map<String, Object> variables) {
        EnsureUtil.ensureNotNull("variables", variables);
        this.ensureCorrelationProcessInstanceVariablesInitialized();
        this.correlationProcessInstanceVariables.putAll(variables);
        return this;
    }

    @Override
    public MessageCorrelationBuilder localVariableEquals(String variableName, Object variableValue) {
        EnsureUtil.ensureNotNull("variableName", (Object)variableName);
        this.ensureCorrelationLocalVariablesInitialized();
        this.correlationLocalVariables.put((Object)variableName, variableValue);
        return this;
    }

    @Override
    public MessageCorrelationBuilder localVariablesEqual(Map<String, Object> variables) {
        EnsureUtil.ensureNotNull("variables", variables);
        this.ensureCorrelationLocalVariablesInitialized();
        this.correlationLocalVariables.putAll(variables);
        return this;
    }

    protected void ensureCorrelationProcessInstanceVariablesInitialized() {
        if (this.correlationProcessInstanceVariables == null) {
            this.correlationProcessInstanceVariables = new VariableMapImpl();
        }
    }

    protected void ensureCorrelationLocalVariablesInitialized() {
        if (this.correlationLocalVariables == null) {
            this.correlationLocalVariables = new VariableMapImpl();
        }
    }

    @Override
    public MessageCorrelationBuilder processInstanceId(String id) {
        EnsureUtil.ensureNotNull("processInstanceId", (Object)id);
        this.processInstanceId = id;
        return this;
    }

    @Override
    public MessageCorrelationBuilder processDefinitionId(String processDefinitionId) {
        EnsureUtil.ensureNotNull("processDefinitionId", (Object)processDefinitionId);
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Override
    public MessageCorrelationBuilder setVariable(String variableName, Object variableValue) {
        EnsureUtil.ensureNotNull("variableName", (Object)variableName);
        this.ensurePayloadProcessInstanceVariablesInitialized();
        this.payloadProcessInstanceVariables.put((Object)variableName, variableValue);
        return this;
    }

    @Override
    public MessageCorrelationBuilder setVariables(Map<String, Object> variables) {
        if (variables != null) {
            this.ensurePayloadProcessInstanceVariablesInitialized();
            this.payloadProcessInstanceVariables.putAll(variables);
        }
        return this;
    }

    protected void ensurePayloadProcessInstanceVariablesInitialized() {
        if (this.payloadProcessInstanceVariables == null) {
            this.payloadProcessInstanceVariables = new VariableMapImpl();
        }
    }

    @Override
    public MessageCorrelationBuilder tenantId(String tenantId) {
        EnsureUtil.ensureNotNull("The tenant-id cannot be null. Use 'withoutTenantId()' if you want to correlate the message to a process definition or an execution which has no tenant-id.", "tenantId", (Object)tenantId);
        this.isTenantIdSet = true;
        this.tenantId = tenantId;
        return this;
    }

    @Override
    public MessageCorrelationBuilder withoutTenantId() {
        this.isTenantIdSet = true;
        this.tenantId = null;
        return this;
    }

    @Override
    public void correlate() {
        this.correlateWithResult();
    }

    @Override
    public MessageCorrelationResult correlateWithResult() {
        this.ensureProcessDefinitionIdNotSet();
        this.ensureProcessInstanceAndTenantIdNotSet();
        return this.execute(new CorrelateMessageCmd(this));
    }

    @Override
    public void correlateExclusively() {
        this.isExclusiveCorrelation = true;
        this.correlate();
    }

    @Override
    public void correlateAll() {
        this.correlateAllWithResult();
    }

    @Override
    public List<MessageCorrelationResult> correlateAllWithResult() {
        this.ensureProcessDefinitionIdNotSet();
        this.ensureProcessInstanceAndTenantIdNotSet();
        return this.execute(new CorrelateAllMessageCmd(this));
    }

    @Override
    public ProcessInstance correlateStartMessage() {
        this.ensureCorrelationVariablesNotSet();
        this.ensureProcessDefinitionAndTenantIdNotSet();
        return this.execute(new CorrelateStartMessageCmd(this));
    }

    protected void ensureProcessDefinitionIdNotSet() {
        if (this.processDefinitionId != null) {
            throw LOG.exceptionCorrelateMessageWithProcessDefinitionId();
        }
    }

    protected void ensureProcessInstanceAndTenantIdNotSet() {
        if (this.processInstanceId != null && this.isTenantIdSet) {
            throw LOG.exceptionCorrelateMessageWithProcessInstanceAndTenantId();
        }
    }

    protected void ensureCorrelationVariablesNotSet() {
        if (this.correlationProcessInstanceVariables != null || this.correlationLocalVariables != null) {
            throw LOG.exceptionCorrelateStartMessageWithCorrelationVariables();
        }
    }

    protected void ensureProcessDefinitionAndTenantIdNotSet() {
        if (this.processDefinitionId != null && this.isTenantIdSet) {
            throw LOG.exceptionCorrelateMessageWithProcessDefinitionAndTenantId();
        }
    }

    protected <T> T execute(Command<T> command) {
        if (this.commandExecutor != null) {
            return this.commandExecutor.execute(command);
        }
        return command.execute(this.commandContext);
    }

    public CommandExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    public CommandContext getCommandContext() {
        return this.commandContext;
    }

    public String getMessageName() {
        return this.messageName;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public Map<String, Object> getCorrelationProcessInstanceVariables() {
        return this.correlationProcessInstanceVariables;
    }

    public Map<String, Object> getCorrelationLocalVariables() {
        return this.correlationLocalVariables;
    }

    public Map<String, Object> getPayloadProcessInstanceVariables() {
        return this.payloadProcessInstanceVariables;
    }

    public boolean isExclusiveCorrelation() {
        return this.isExclusiveCorrelation;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public boolean isTenantIdSet() {
        return this.isTenantIdSet;
    }
}

