/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import org.camunda.bpm.engine.impl.cmd.AbstractProcessInstanceModificationCommand;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.pvm.delegate.ModificationObserverBehavior;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;

public abstract class AbstractInstanceCancellationCmd
extends AbstractProcessInstanceModificationCommand {
    public AbstractInstanceCancellationCmd(String processInstanceId) {
        super(processInstanceId);
    }

    @Override
    public Void execute(CommandContext commandContext) {
        ExecutionEntity sourceInstanceExecution;
        ExecutionEntity topmostCancellableExecution = sourceInstanceExecution = this.determineSourceInstanceExecution(commandContext);
        ExecutionEntity parentScopeExecution = (ExecutionEntity)topmostCancellableExecution.getParentScopeExecution(false);
        while (parentScopeExecution != null && parentScopeExecution.getNonEventScopeExecutions().size() <= 1) {
            topmostCancellableExecution = parentScopeExecution;
            parentScopeExecution = (ExecutionEntity)topmostCancellableExecution.getParentScopeExecution(false);
        }
        if (topmostCancellableExecution.isPreserveScope()) {
            topmostCancellableExecution.interrupt("Cancelled due to process instance modification", this.skipCustomListeners, this.skipIoMappings);
            topmostCancellableExecution.leaveActivityInstance();
            topmostCancellableExecution.setActivity(null);
        } else {
            topmostCancellableExecution.deleteCascade("Cancelled due to process instance modification", this.skipCustomListeners, this.skipIoMappings);
            this.handleChildRemovalInScope(topmostCancellableExecution);
        }
        return null;
    }

    protected void handleChildRemovalInScope(ExecutionEntity removedExecution) {
        ExecutionEntity executionInParentScope;
        ActivityImpl activity = removedExecution.getActivity();
        if (activity == null) {
            return;
        }
        ScopeImpl flowScope = activity.getFlowScope();
        PvmExecutionImpl scopeExecution = removedExecution.getParentScopeExecution(false);
        ExecutionEntity executionEntity = executionInParentScope = removedExecution.isConcurrent() ? removedExecution : removedExecution.getParent();
        if (flowScope.getActivityBehavior() != null && flowScope.getActivityBehavior() instanceof ModificationObserverBehavior) {
            ModificationObserverBehavior behavior = (ModificationObserverBehavior)flowScope.getActivityBehavior();
            behavior.destroyInnerInstance(executionInParentScope);
        } else if (executionInParentScope.isConcurrent()) {
            ((PvmExecutionImpl)executionInParentScope).remove();
            scopeExecution.tryPruneLastConcurrentChild();
            scopeExecution.forceUpdate();
        }
    }

    protected abstract ExecutionEntity determineSourceInstanceExecution(CommandContext var1);

    protected ExecutionEntity findSuperExecution(ExecutionEntity parentScopeExecution, ExecutionEntity topmostCancellableExecution) {
        ExecutionEntity superExecution = null;
        if (parentScopeExecution == null) {
            superExecution = topmostCancellableExecution.getSuperExecution();
        }
        return superExecution;
    }
}

