/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.json;

import java.util.List;
import org.camunda.bpm.engine.impl.QueryEntityRelationCondition;
import org.camunda.bpm.engine.impl.QueryPropertyImpl;
import org.camunda.bpm.engine.impl.json.JsonArrayConverter;
import org.camunda.bpm.engine.impl.json.JsonArrayOfObjectsConverter;
import org.camunda.bpm.engine.impl.json.JsonObjectConverter;
import org.camunda.bpm.engine.impl.util.JsonUtil;
import org.camunda.bpm.engine.impl.util.json.JSONObject;
import org.camunda.bpm.engine.query.QueryProperty;

public class JsonQueryFilteringPropertyConverter
extends JsonObjectConverter<QueryEntityRelationCondition> {
    protected static JsonQueryFilteringPropertyConverter INSTANCE = new JsonQueryFilteringPropertyConverter();
    protected static JsonArrayConverter<List<QueryEntityRelationCondition>> ARRAY_CONVERTER = new JsonArrayOfObjectsConverter<QueryEntityRelationCondition>(INSTANCE);
    public static final String BASE_PROPERTY = "baseField";
    public static final String COMPARISON_PROPERTY = "comparisonField";
    public static final String SCALAR_VALUE = "value";

    @Override
    public JSONObject toJsonObject(QueryEntityRelationCondition filteringProperty) {
        Object scalarValue;
        JSONObject jsonObject = new JSONObject();
        JsonUtil.addField(jsonObject, BASE_PROPERTY, filteringProperty.getProperty().getName());
        QueryProperty comparisonProperty = filteringProperty.getComparisonProperty();
        if (comparisonProperty != null) {
            JsonUtil.addField(jsonObject, COMPARISON_PROPERTY, comparisonProperty.getName());
        }
        if ((scalarValue = filteringProperty.getScalarValue()) != null) {
            JsonUtil.addField(jsonObject, SCALAR_VALUE, scalarValue);
        }
        return jsonObject;
    }

    @Override
    public QueryEntityRelationCondition toObject(JSONObject jsonObject) {
        String scalarValue = null;
        if (jsonObject.has(SCALAR_VALUE)) {
            scalarValue = jsonObject.getString(SCALAR_VALUE);
        }
        QueryPropertyImpl baseProperty = null;
        if (jsonObject.has(BASE_PROPERTY)) {
            baseProperty = new QueryPropertyImpl(jsonObject.getString(BASE_PROPERTY));
        }
        QueryPropertyImpl comparisonProperty = null;
        if (jsonObject.has(COMPARISON_PROPERTY)) {
            comparisonProperty = new QueryPropertyImpl(jsonObject.getString(COMPARISON_PROPERTY));
        }
        return new QueryEntityRelationCondition(baseProperty, comparisonProperty, scalarValue);
    }
}

