/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.history.HistoricDetail;
import org.camunda.bpm.engine.impl.HistoricDetailQueryImpl;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.history.event.HistoricDetailEventEntity;
import org.camunda.bpm.engine.impl.persistence.AbstractHistoricManager;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;

public class HistoricDetailManager
extends AbstractHistoricManager {
    public void deleteHistoricDetailsByProcessInstanceIds(List<String> historicProcessInstanceIds) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("processInstanceIds", historicProcessInstanceIds);
        this.deleteHistoricDetails(parameters);
    }

    public void deleteHistoricDetailsByTaskProcessInstanceIds(List<String> historicProcessInstanceIds) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("taskProcessInstanceIds", historicProcessInstanceIds);
        this.deleteHistoricDetails(parameters);
    }

    public void deleteHistoricDetailsByCaseInstanceIds(List<String> historicCaseInstanceIds) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("caseInstanceIds", historicCaseInstanceIds);
        this.deleteHistoricDetails(parameters);
    }

    public void deleteHistoricDetailsByTaskCaseInstanceIds(List<String> historicCaseInstanceIds) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("taskCaseInstanceIds", historicCaseInstanceIds);
        this.deleteHistoricDetails(parameters);
    }

    public void deleteHistoricDetails(Map<String, Object> parameters) {
        this.getDbEntityManager().deletePreserveOrder(ByteArrayEntity.class, "deleteHistoricDetailByteArraysByIds", parameters);
        this.getDbEntityManager().deletePreserveOrder(HistoricDetailEventEntity.class, "deleteHistoricDetailsByIds", parameters);
    }

    public long findHistoricDetailCountByQueryCriteria(HistoricDetailQueryImpl historicVariableUpdateQuery) {
        this.configureQuery(historicVariableUpdateQuery);
        return (Long)this.getDbEntityManager().selectOne("selectHistoricDetailCountByQueryCriteria", historicVariableUpdateQuery);
    }

    public List<HistoricDetail> findHistoricDetailsByQueryCriteria(HistoricDetailQueryImpl historicVariableUpdateQuery, Page page) {
        this.configureQuery(historicVariableUpdateQuery);
        return this.getDbEntityManager().selectList("selectHistoricDetailsByQueryCriteria", historicVariableUpdateQuery, page);
    }

    public void deleteHistoricDetailsByTaskId(String taskId) {
        if (this.isHistoryEnabled()) {
            List<HistoricDetail> historicDetails = this.findHistoricDetailsByTaskId(taskId);
            for (HistoricDetail historicDetail : historicDetails) {
                ((HistoricDetailEventEntity)((Object)historicDetail)).delete();
            }
            List<HistoricDetailEventEntity> cachedHistoricDetails = this.getDbEntityManager().getCachedEntitiesByType(HistoricDetailEventEntity.class);
            for (HistoricDetailEventEntity historicDetail : cachedHistoricDetails) {
                if (!taskId.equals(historicDetail.getTaskId())) continue;
                historicDetail.delete();
            }
        }
    }

    public List<HistoricDetail> findHistoricDetailsByTaskId(String taskId) {
        return this.getDbEntityManager().selectList("selectHistoricDetailsByTaskId", taskId);
    }

    protected void configureQuery(HistoricDetailQueryImpl query) {
        this.getAuthorizationManager().configureHistoricDetailQuery(query);
        this.getTenantManager().configureQuery(query);
    }
}

