/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.variable.serializer.jpa;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.variable.serializer.AbstractTypedValueSerializer;
import org.camunda.bpm.engine.impl.variable.serializer.ValueFields;
import org.camunda.bpm.engine.impl.variable.serializer.jpa.EntityManagerSession;
import org.camunda.bpm.engine.impl.variable.serializer.jpa.JPAEntityMappings;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.impl.value.UntypedValueImpl;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.value.ObjectValue;
import org.camunda.bpm.engine.variable.value.TypedValue;

public class JPAVariableSerializer
extends AbstractTypedValueSerializer<ObjectValue> {
    public static final String NAME = "jpa";
    private JPAEntityMappings mappings = new JPAEntityMappings();

    public JPAVariableSerializer() {
        super((ValueType)ValueType.OBJECT);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    protected boolean canWriteValue(TypedValue value) {
        if (this.isDeserializedObjectValue(value) || value instanceof UntypedValueImpl) {
            return value.getValue() == null || this.mappings.isJPAEntity(value.getValue());
        }
        return false;
    }

    protected boolean isDeserializedObjectValue(TypedValue value) {
        return value instanceof ObjectValue && ((ObjectValue)value).isDeserialized();
    }

    @Override
    public ObjectValue convertToTypedValue(UntypedValueImpl untypedValue) {
        return (ObjectValue)Variables.objectValue((Object)untypedValue.getValue()).create();
    }

    @Override
    public void writeValue(ObjectValue objectValue, ValueFields valueFields) {
        EntityManagerSession entityManagerSession = Context.getCommandContext().getSession(EntityManagerSession.class);
        if (entityManagerSession == null) {
            throw new ProcessEngineException("Cannot set JPA variable: " + EntityManagerSession.class + " not configured");
        }
        entityManagerSession.flush();
        Object value = objectValue.getValue();
        if (value != null) {
            String className = this.mappings.getJPAClassString(value);
            String idString = this.mappings.getJPAIdString(value);
            valueFields.setTextValue(className);
            valueFields.setTextValue2(idString);
        } else {
            valueFields.setTextValue(null);
            valueFields.setTextValue2(null);
        }
    }

    @Override
    public ObjectValue readValue(ValueFields valueFields, boolean deserializeObjectValue) {
        if (valueFields.getTextValue() != null && valueFields.getTextValue2() != null) {
            Object jpaEntity = this.mappings.getJPAEntity(valueFields.getTextValue(), valueFields.getTextValue2());
            return (ObjectValue)Variables.objectValue((Object)jpaEntity).create();
        }
        return (ObjectValue)Variables.objectValue(null).create();
    }
}

