/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.client.spring.impl.client;

import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.camunda.bpm.client.ExternalTaskClient;
import org.camunda.bpm.client.spring.annotation.EnableExternalTaskClient;
import org.camunda.bpm.client.spring.impl.client.ClientConfiguration;
import org.camunda.bpm.client.spring.impl.client.ClientFactory;
import org.camunda.bpm.client.spring.impl.client.util.ClientLoggerUtil;
import org.camunda.bpm.client.spring.impl.util.AnnotationUtil;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.AnnotationMetadata;

public class ClientPostProcessor
implements BeanDefinitionRegistryPostProcessor {
    protected static final ClientLoggerUtil LOG = ClientLoggerUtil.CLIENT_LOGGER;
    protected static final String BEAN_NAME = "externalTaskClient";
    protected Class<? extends ClientFactory> externalTaskClientFactoryClass;

    public ClientPostProcessor() {
        this(ClientFactory.class);
    }

    public ClientPostProcessor(Class<? extends ClientFactory> externalTaskClientFactoryClass) {
        this.externalTaskClientFactoryClass = externalTaskClientFactoryClass;
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        EnableExternalTaskClient annotation;
        String clientBeanName = this.getClientBeanName((ListableBeanFactory)registry);
        if (clientBeanName != null) {
            BeanDefinition beanDefinition = registry.getBeanDefinition(clientBeanName);
            String beanClassName = beanDefinition.getBeanClassName();
            LOG.beanCreationSkipped(clientBeanName, beanClassName);
            return;
        }
        String classBeanName = this.getClassBeanName((ListableBeanFactory)registry);
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        if (classBeanName != null && (annotation = this.getAnnotation(registry, classBeanName)) != null) {
            clientConfiguration.fromAnnotation(annotation);
        }
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(this.externalTaskClientFactoryClass).setDestroyMethodName("close");
        beanDefinitionBuilder.addPropertyValue("clientConfiguration", (Object)clientConfiguration);
        AbstractBeanDefinition clientBeanDefinition = beanDefinitionBuilder.getBeanDefinition();
        registry.registerBeanDefinition(BEAN_NAME, (BeanDefinition)clientBeanDefinition);
        LOG.registered(BEAN_NAME);
    }

    protected String getClassBeanName(ListableBeanFactory listableBeanFactory) {
        String[] beanNames = listableBeanFactory.getBeanNamesForAnnotation(EnableExternalTaskClient.class);
        List classBeanNames = Arrays.stream(beanNames).filter(this.isClassAnnotation(listableBeanFactory)).collect(Collectors.toList());
        int classBeanNameCount = classBeanNames.size();
        if (classBeanNameCount > 1) {
            throw LOG.noUniqueAnnotation();
        }
        if (classBeanNameCount == 1) {
            return (String)classBeanNames.get(0);
        }
        return null;
    }

    Predicate<String> isClassAnnotation(ListableBeanFactory listableBeanFactory) {
        return beanName -> ((BeanDefinitionRegistry)listableBeanFactory).getBeanDefinition(beanName).getSource() == null;
    }

    protected EnableExternalTaskClient getAnnotation(BeanDefinitionRegistry registry, String classBeanName) {
        BeanDefinition beanDefinitionConfig = registry.getBeanDefinition(classBeanName);
        AnnotatedBeanDefinition annotatedBeanDefinition = (AnnotatedBeanDefinition)beanDefinitionConfig;
        AnnotationMetadata metadata = annotatedBeanDefinition.getMetadata();
        return AnnotationUtil.get(EnableExternalTaskClient.class, (AnnotatedTypeMetadata)metadata);
    }

    protected String getClientBeanName(ListableBeanFactory listableBeanFactory) {
        String[] beanNamesForType = listableBeanFactory.getBeanNamesForType(ExternalTaskClient.class);
        if (beanNamesForType.length > 1) {
            throw LOG.noUniqueClientException();
        }
        if (beanNamesForType.length == 1) {
            return beanNamesForType[0];
        }
        return null;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }
}

