/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.client.backoff;

import java.util.List;
import org.camunda.bpm.client.backoff.BackoffStrategy;
import org.camunda.bpm.client.task.ExternalTask;

public class ExponentialBackoffStrategy
implements BackoffStrategy {
    protected long initTime;
    protected float factor;
    protected int level;
    protected long maxTime;

    public ExponentialBackoffStrategy() {
        this(500L, 2.0f, 60000L);
    }

    public ExponentialBackoffStrategy(long initTime, float factor, long maxTime) {
        this.initTime = initTime;
        this.factor = factor;
        this.level = 0;
        this.maxTime = maxTime;
    }

    @Override
    public void reconfigure(List<ExternalTask> externalTasks) {
        this.level = externalTasks.isEmpty() ? ++this.level : 0;
    }

    @Override
    public long calculateBackoffTime() {
        if (this.level == 0) {
            return 0L;
        }
        long backoffTime = (long)((double)this.initTime * Math.pow(this.factor, this.level - 1));
        return Math.min(backoffTime, this.maxTime);
    }
}

