/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.client.variable.impl;

import org.camunda.bpm.client.variable.impl.TypedValueField;
import org.camunda.bpm.client.variable.impl.ValueMapper;
import org.camunda.bpm.client.variable.impl.ValueMappers;
import org.camunda.bpm.client.variable.impl.value.DeferredFileValueImpl;
import org.camunda.bpm.engine.variable.value.SerializableValue;
import org.camunda.bpm.engine.variable.value.TypedValue;

public class VariableValue<T extends TypedValue> {
    protected String processInstanceId;
    protected String variableName;
    protected TypedValueField typedValueField;
    protected ValueMappers mappers;
    protected ValueMapper<T> serializer;
    protected T cachedValue;

    public VariableValue(String processInstanceId, String variableName, TypedValueField typedValueField, ValueMappers mappers) {
        this.processInstanceId = processInstanceId;
        this.variableName = variableName;
        this.typedValueField = typedValueField;
        this.mappers = mappers;
    }

    public Object getValue() {
        T typedValue = this.getTypedValue();
        if (typedValue != null) {
            return typedValue.getValue();
        }
        return null;
    }

    public T getTypedValue() {
        return this.getTypedValue(true);
    }

    public T getTypedValue(boolean deserializeValue) {
        if (this.cachedValue != null && this.cachedValue instanceof SerializableValue) {
            SerializableValue serializableValue = (SerializableValue)this.cachedValue;
            if (deserializeValue && !serializableValue.isDeserialized()) {
                this.cachedValue = null;
            }
        }
        if (this.cachedValue == null) {
            this.cachedValue = this.getSerializer().readValue(this.typedValueField, deserializeValue);
            if (this.cachedValue instanceof DeferredFileValueImpl) {
                DeferredFileValueImpl fileValue = (DeferredFileValueImpl)this.cachedValue;
                fileValue.setProcessInstanceId(this.processInstanceId);
                fileValue.setVariableName(this.variableName);
            }
        }
        return this.cachedValue;
    }

    public ValueMapper<T> getSerializer() {
        if (this.serializer == null) {
            this.serializer = this.mappers.findMapperForTypedValueField(this.typedValueField);
        }
        return this.serializer;
    }

    public String toString() {
        return "VariableValue [cachedValue=" + this.cachedValue + ", processInstanceId=" + this.processInstanceId + ", variableName=" + this.variableName + ", typedValueField=" + this.typedValueField + "]";
    }
}

