/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.assertions;

import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.FormService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.engine.runtime.ExecutionQuery;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.assertions.AbstractProcessAssert;
import org.camunda.bpm.engine.test.assertions.ProcessEngineAssertions;
import org.camunda.bpm.engine.test.assertions.ProcessInstanceAssert;

public class ProcessEngineTests
extends ProcessEngineAssertions {
    protected ProcessEngineTests() {
    }

    public static RuntimeService runtimeService() {
        return ProcessEngineTests.processEngine().getRuntimeService();
    }

    public static AuthorizationService authorizationService() {
        return ProcessEngineTests.processEngine().getAuthorizationService();
    }

    public static FormService formService() {
        return ProcessEngineTests.processEngine().getFormService();
    }

    public static HistoryService historyService() {
        return ProcessEngineTests.processEngine().getHistoryService();
    }

    public static IdentityService identityService() {
        return ProcessEngineTests.processEngine().getIdentityService();
    }

    public static ManagementService managementService() {
        return ProcessEngineTests.processEngine().getManagementService();
    }

    public static RepositoryService repositoryService() {
        return ProcessEngineTests.processEngine().getRepositoryService();
    }

    public static TaskService taskService() {
        return ProcessEngineTests.processEngine().getTaskService();
    }

    public static TaskQuery taskQuery() {
        return ProcessEngineTests.taskService().createTaskQuery();
    }

    public static JobQuery jobQuery() {
        return ProcessEngineTests.managementService().createJobQuery();
    }

    public static ProcessInstanceQuery processInstanceQuery() {
        return ProcessEngineTests.runtimeService().createProcessInstanceQuery();
    }

    public static ProcessDefinitionQuery processDefinitionQuery() {
        return ProcessEngineTests.repositoryService().createProcessDefinitionQuery();
    }

    public static ExecutionQuery executionQuery() {
        return ProcessEngineTests.runtimeService().createExecutionQuery();
    }

    public static Map<String, Object> withVariables(String key, Object value, Object ... furtherKeyValuePairs) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Illegal call of withVariables(key = '%s', value = '%s', ...) - key must not be null!", key, value));
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(key, value);
        if (furtherKeyValuePairs != null) {
            if (furtherKeyValuePairs.length % 2 != 0) {
                throw new IllegalArgumentException(String.format("Illegal call of withVariables() - must have an even number of arguments, but found length = %s!", furtherKeyValuePairs.length + 2));
            }
            for (int i = 0; i < furtherKeyValuePairs.length; i += 2) {
                if (!(furtherKeyValuePairs[i] instanceof String)) {
                    throw new IllegalArgumentException(String.format("Illegal call of withVariables() - keys must be strings, found object of type '%s'!", furtherKeyValuePairs[i] != null ? furtherKeyValuePairs[i].getClass().getName() : null));
                }
                map.put((String)furtherKeyValuePairs[i], furtherKeyValuePairs[i + 1]);
            }
        }
        return map;
    }

    public static Task task() {
        return ProcessEngineTests.task(ProcessEngineTests.taskQuery());
    }

    public static Task task(ProcessInstance processInstance) {
        return ProcessEngineTests.task(ProcessEngineTests.taskQuery(), processInstance);
    }

    public static Task task(String taskDefinitionKey) {
        ProcessEngineTests.assertThat((String)taskDefinitionKey).isNotNull();
        return ProcessEngineTests.task(ProcessEngineTests.taskQuery().taskDefinitionKey(taskDefinitionKey));
    }

    public static Task task(String taskDefinitionKey, ProcessInstance processInstance) {
        ProcessEngineTests.assertThat((String)taskDefinitionKey).isNotNull();
        return ProcessEngineTests.task(ProcessEngineTests.taskQuery().taskDefinitionKey(taskDefinitionKey), processInstance);
    }

    public static Task task(TaskQuery taskQuery) {
        ProcessInstanceAssert lastAssert = AbstractProcessAssert.getLastAssert(ProcessInstanceAssert.class);
        if (lastAssert == null) {
            throw new IllegalStateException("Call a process instance assertion first - e.g. assertThat(processInstance)... !");
        }
        return ProcessEngineTests.task(taskQuery, (ProcessInstance)lastAssert.getActual());
    }

    public static Task task(TaskQuery taskQuery, ProcessInstance processInstance) {
        return (Task)((ProcessInstanceAssert)ProcessEngineTests.assertThat(processInstance).isNotNull()).task(taskQuery).getActual();
    }

    public static ProcessDefinition processDefinition() {
        ProcessInstanceAssert lastAssert = AbstractProcessAssert.getLastAssert(ProcessInstanceAssert.class);
        if (lastAssert == null) {
            throw new IllegalStateException("Call a process instance assertion first - e.g. assertThat(processInstance)... !");
        }
        return ProcessEngineTests.processDefinition((ProcessInstance)lastAssert.getActual());
    }

    public static ProcessDefinition processDefinition(ProcessInstance processInstance) {
        ProcessEngineTests.assertThat(processInstance).isNotNull();
        return ProcessEngineTests.processDefinition(ProcessEngineTests.processDefinitionQuery().processDefinitionId(processInstance.getProcessDefinitionId()));
    }

    public static ProcessDefinition processDefinition(String processDefinitionKey) {
        ProcessEngineTests.assertThat((String)processDefinitionKey).isNotNull();
        return ProcessEngineTests.processDefinition(ProcessEngineTests.processDefinitionQuery().processDefinitionKey(processDefinitionKey));
    }

    public static ProcessDefinition processDefinition(ProcessDefinitionQuery processDefinitionQuery) {
        return (ProcessDefinition)processDefinitionQuery.singleResult();
    }

    public static ProcessInstance calledProcessInstance() {
        return ProcessEngineTests.calledProcessInstance(ProcessEngineTests.processInstanceQuery());
    }

    public static ProcessInstance calledProcessInstance(ProcessInstance processInstance) {
        return ProcessEngineTests.calledProcessInstance(ProcessEngineTests.processInstanceQuery(), processInstance);
    }

    public static ProcessInstance calledProcessInstance(String processDefinitionKey) {
        ProcessEngineTests.assertThat((String)processDefinitionKey).isNotNull();
        return ProcessEngineTests.calledProcessInstance(ProcessEngineTests.processInstanceQuery().processDefinitionKey(processDefinitionKey));
    }

    public static ProcessInstance calledProcessInstance(String processDefinitionKey, ProcessInstance processInstance) {
        ProcessEngineTests.assertThat((String)processDefinitionKey).isNotNull();
        return ProcessEngineTests.calledProcessInstance(ProcessEngineTests.processInstanceQuery().processDefinitionKey(processDefinitionKey), processInstance);
    }

    public static ProcessInstance calledProcessInstance(ProcessInstanceQuery processInstanceQuery) {
        ProcessInstanceAssert lastAssert = AbstractProcessAssert.getLastAssert(ProcessInstanceAssert.class);
        if (lastAssert == null) {
            throw new IllegalStateException("Call a process instance assertion first - e.g. assertThat(processInstance)... !");
        }
        return ProcessEngineTests.calledProcessInstance(processInstanceQuery, (ProcessInstance)lastAssert.getActual());
    }

    public static ProcessInstance calledProcessInstance(ProcessInstanceQuery processInstanceQuery, ProcessInstance processInstance) {
        return (ProcessInstance)((ProcessInstanceAssert)ProcessEngineTests.assertThat(processInstance).isNotNull()).calledProcessInstance(processInstanceQuery).getActual();
    }

    public static Job job() {
        return ProcessEngineTests.job(ProcessEngineTests.jobQuery());
    }

    public static Job job(ProcessInstance processInstance) {
        return ProcessEngineTests.job(ProcessEngineTests.jobQuery(), processInstance);
    }

    public static Job job(String activityId) {
        ProcessInstanceAssert lastAssert = AbstractProcessAssert.getLastAssert(ProcessInstanceAssert.class);
        if (lastAssert == null) {
            throw new IllegalStateException("Call a process instance assertion first - e.g. assertThat(processInstance)... !");
        }
        return ProcessEngineTests.job(activityId, (ProcessInstance)lastAssert.getActual());
    }

    public static Job job(String activityId, ProcessInstance processInstance) {
        return (Job)((ProcessInstanceAssert)ProcessEngineTests.assertThat(processInstance).isNotNull()).job(activityId).getActual();
    }

    public static Job job(JobQuery jobQuery) {
        ProcessInstanceAssert lastAssert = AbstractProcessAssert.getLastAssert(ProcessInstanceAssert.class);
        if (lastAssert == null) {
            throw new IllegalStateException("Call a process instance assertion first - e.g. assertThat(processInstance)... !");
        }
        return ProcessEngineTests.job(jobQuery, (ProcessInstance)lastAssert.getActual());
    }

    public static Job job(JobQuery jobQuery, ProcessInstance processInstance) {
        return (Job)((ProcessInstanceAssert)ProcessEngineTests.assertThat(processInstance).isNotNull()).job(jobQuery).getActual();
    }

    public static Task claim(Task task, String assigneeUserId) {
        if (task == null || assigneeUserId == null) {
            throw new IllegalArgumentException(String.format("Illegal call of claim(task = '%s', assigneeUserId = '%s') - both must not be null!", task, assigneeUserId));
        }
        ProcessEngineTests.taskService().claim(task.getId(), assigneeUserId);
        return (Task)ProcessEngineTests.taskQuery().taskId(task.getId()).singleResult();
    }

    public static Task unclaim(Task task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Illegal call of unclaim(task = '%s') - task must not be null!", task));
        }
        ProcessEngineTests.taskService().claim(task.getId(), null);
        return (Task)ProcessEngineTests.taskQuery().taskId(task.getId()).singleResult();
    }

    public static void complete(Task task, Map<String, Object> variables) {
        if (task == null || variables == null) {
            throw new IllegalArgumentException(String.format("Illegal call of claim(task = '%s', variables = '%s') - both must not be null!", task, variables));
        }
        ProcessEngineTests.taskService().complete(task.getId(), variables);
    }

    public static void complete(Task task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Illegal call of claim(task = '%s') - must not be null!", task));
        }
        ProcessEngineTests.taskService().complete(task.getId());
    }

    public static void execute(Job job) {
        if (job == null) {
            throw new IllegalArgumentException(String.format("Illegal call of execute(job = '%s') - must not be null!", job));
        }
        Job current = (Job)ProcessEngineTests.jobQuery().jobId(job.getId()).singleResult();
        if (current == null) {
            throw new IllegalStateException(String.format("Illegal state when calling execute(job = '%s') - job does not exist anymore!", job));
        }
        ProcessEngineTests.managementService().executeJob(job.getId());
    }
}

