/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.apache.http.impl.client;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import keycloakjar.org.apache.http.HttpException;
import keycloakjar.org.apache.http.HttpHost;
import keycloakjar.org.apache.http.HttpRequest;
import keycloakjar.org.apache.http.annotation.Contract;
import keycloakjar.org.apache.http.annotation.ThreadingBehavior;
import keycloakjar.org.apache.http.client.ClientProtocolException;
import keycloakjar.org.apache.http.client.config.RequestConfig;
import keycloakjar.org.apache.http.client.methods.CloseableHttpResponse;
import keycloakjar.org.apache.http.client.methods.Configurable;
import keycloakjar.org.apache.http.client.methods.HttpExecutionAware;
import keycloakjar.org.apache.http.client.methods.HttpRequestWrapper;
import keycloakjar.org.apache.http.client.protocol.HttpClientContext;
import keycloakjar.org.apache.http.conn.ClientConnectionManager;
import keycloakjar.org.apache.http.conn.ClientConnectionRequest;
import keycloakjar.org.apache.http.conn.HttpClientConnectionManager;
import keycloakjar.org.apache.http.conn.ManagedClientConnection;
import keycloakjar.org.apache.http.conn.routing.HttpRoute;
import keycloakjar.org.apache.http.conn.scheme.SchemeRegistry;
import keycloakjar.org.apache.http.impl.DefaultConnectionReuseStrategy;
import keycloakjar.org.apache.http.impl.client.CloseableHttpClient;
import keycloakjar.org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import keycloakjar.org.apache.http.impl.execchain.MinimalClientExec;
import keycloakjar.org.apache.http.params.BasicHttpParams;
import keycloakjar.org.apache.http.params.HttpParams;
import keycloakjar.org.apache.http.protocol.BasicHttpContext;
import keycloakjar.org.apache.http.protocol.HttpContext;
import keycloakjar.org.apache.http.protocol.HttpRequestExecutor;
import keycloakjar.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
class MinimalHttpClient
extends CloseableHttpClient {
    private final HttpClientConnectionManager connManager;
    private final MinimalClientExec requestExecutor;
    private final HttpParams params;

    public MinimalHttpClient(HttpClientConnectionManager connManager) {
        this.connManager = Args.notNull(connManager, "HTTP connection manager");
        this.requestExecutor = new MinimalClientExec(new HttpRequestExecutor(), connManager, DefaultConnectionReuseStrategy.INSTANCE, DefaultConnectionKeepAliveStrategy.INSTANCE);
        this.params = new BasicHttpParams();
    }

    @Override
    protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        Args.notNull(target, "Target host");
        Args.notNull(request, "HTTP request");
        HttpExecutionAware execAware = null;
        if (request instanceof HttpExecutionAware) {
            execAware = (HttpExecutionAware)((Object)request);
        }
        try {
            HttpRequestWrapper wrapper = HttpRequestWrapper.wrap(request);
            HttpClientContext localcontext = HttpClientContext.adapt(context != null ? context : new BasicHttpContext());
            HttpRoute route = new HttpRoute(target);
            RequestConfig config = null;
            if (request instanceof Configurable) {
                config = ((Configurable)((Object)request)).getConfig();
            }
            if (config != null) {
                localcontext.setRequestConfig(config);
            }
            return this.requestExecutor.execute(route, wrapper, localcontext, execAware);
        }
        catch (HttpException httpException) {
            throw new ClientProtocolException(httpException);
        }
    }

    @Override
    public HttpParams getParams() {
        return this.params;
    }

    @Override
    public void close() {
        this.connManager.shutdown();
    }

    @Override
    public ClientConnectionManager getConnectionManager() {
        return new ClientConnectionManager(){

            @Override
            public void shutdown() {
                MinimalHttpClient.this.connManager.shutdown();
            }

            @Override
            public ClientConnectionRequest requestConnection(HttpRoute route, Object state) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void releaseConnection(ManagedClientConnection conn, long validDuration, TimeUnit timeUnit) {
                throw new UnsupportedOperationException();
            }

            @Override
            public SchemeRegistry getSchemeRegistry() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void closeIdleConnections(long idletime, TimeUnit timeUnit) {
                MinimalHttpClient.this.connManager.closeIdleConnections(idletime, timeUnit);
            }

            @Override
            public void closeExpiredConnections() {
                MinimalHttpClient.this.connManager.closeExpiredConnections();
            }
        };
    }
}

