/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.apache.http.protocol;

import java.io.IOException;
import keycloakjar.org.apache.http.HttpException;
import keycloakjar.org.apache.http.HttpRequest;
import keycloakjar.org.apache.http.HttpRequestInterceptor;
import keycloakjar.org.apache.http.annotation.Contract;
import keycloakjar.org.apache.http.annotation.ThreadingBehavior;
import keycloakjar.org.apache.http.protocol.HttpContext;
import keycloakjar.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestConnControl
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        if (!request.containsHeader("Connection")) {
            request.addHeader("Connection", "Keep-Alive");
        }
    }
}

