/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.web.context.support;

import java.io.IOException;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import keycloakjar.org.springframework.context.i18n.LocaleContextHolder;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;
import keycloakjar.org.springframework.util.StringUtils;
import keycloakjar.org.springframework.web.HttpRequestHandler;
import keycloakjar.org.springframework.web.HttpRequestMethodNotSupportedException;
import keycloakjar.org.springframework.web.context.WebApplicationContext;
import keycloakjar.org.springframework.web.context.support.WebApplicationContextUtils;

public class HttpRequestHandlerServlet
extends HttpServlet {
    @Nullable
    private HttpRequestHandler target;

    public void init() throws ServletException {
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext(this.getServletContext());
        this.target = (HttpRequestHandler)wac.getBean(this.getServletName(), HttpRequestHandler.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Assert.state(this.target != null, "No HttpRequestHandler available");
        LocaleContextHolder.setLocale((Locale)request.getLocale());
        try {
            this.target.handleRequest(request, response);
        }
        catch (HttpRequestMethodNotSupportedException ex) {
            Object[] supportedMethods = ex.getSupportedMethods();
            if (supportedMethods != null) {
                response.setHeader("Allow", StringUtils.arrayToDelimitedString(supportedMethods, ", "));
            }
            response.sendError(405, ex.getMessage());
        }
        finally {
            LocaleContextHolder.resetLocaleContext();
        }
    }
}

