/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.apache.hc.core5.http.impl.bootstrap;

import java.util.ArrayList;
import java.util.List;
import keycloakjar.org.apache.hc.core5.function.Callback;
import keycloakjar.org.apache.hc.core5.function.Decorator;
import keycloakjar.org.apache.hc.core5.function.Supplier;
import keycloakjar.org.apache.hc.core5.http.ConnectionReuseStrategy;
import keycloakjar.org.apache.hc.core5.http.config.CharCodingConfig;
import keycloakjar.org.apache.hc.core5.http.config.Http1Config;
import keycloakjar.org.apache.hc.core5.http.config.NamedElementChain;
import keycloakjar.org.apache.hc.core5.http.impl.DefaultConnectionReuseStrategy;
import keycloakjar.org.apache.hc.core5.http.impl.DefaultContentLengthStrategy;
import keycloakjar.org.apache.hc.core5.http.impl.Http1StreamListener;
import keycloakjar.org.apache.hc.core5.http.impl.HttpProcessors;
import keycloakjar.org.apache.hc.core5.http.impl.bootstrap.FilterEntry;
import keycloakjar.org.apache.hc.core5.http.impl.bootstrap.HandlerEntry;
import keycloakjar.org.apache.hc.core5.http.impl.bootstrap.HttpAsyncServer;
import keycloakjar.org.apache.hc.core5.http.impl.bootstrap.StandardFilter;
import keycloakjar.org.apache.hc.core5.http.impl.nio.DefaultHttpRequestParserFactory;
import keycloakjar.org.apache.hc.core5.http.impl.nio.DefaultHttpResponseWriterFactory;
import keycloakjar.org.apache.hc.core5.http.impl.nio.ServerHttp1IOEventHandlerFactory;
import keycloakjar.org.apache.hc.core5.http.impl.nio.ServerHttp1StreamDuplexerFactory;
import keycloakjar.org.apache.hc.core5.http.nio.AsyncFilterHandler;
import keycloakjar.org.apache.hc.core5.http.nio.AsyncServerExchangeHandler;
import keycloakjar.org.apache.hc.core5.http.nio.AsyncServerRequestHandler;
import keycloakjar.org.apache.hc.core5.http.nio.HandlerFactory;
import keycloakjar.org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import keycloakjar.org.apache.hc.core5.http.nio.support.AsyncServerExpectationFilter;
import keycloakjar.org.apache.hc.core5.http.nio.support.AsyncServerFilterChainElement;
import keycloakjar.org.apache.hc.core5.http.nio.support.AsyncServerFilterChainExchangeHandlerFactory;
import keycloakjar.org.apache.hc.core5.http.nio.support.BasicAsyncServerExpectationDecorator;
import keycloakjar.org.apache.hc.core5.http.nio.support.BasicServerExchangeHandler;
import keycloakjar.org.apache.hc.core5.http.nio.support.DefaultAsyncResponseExchangeHandlerFactory;
import keycloakjar.org.apache.hc.core5.http.nio.support.TerminalAsyncServerFilter;
import keycloakjar.org.apache.hc.core5.http.protocol.HttpProcessor;
import keycloakjar.org.apache.hc.core5.http.protocol.LookupRegistry;
import keycloakjar.org.apache.hc.core5.http.protocol.RequestHandlerRegistry;
import keycloakjar.org.apache.hc.core5.http.protocol.UriPatternType;
import keycloakjar.org.apache.hc.core5.net.InetAddressUtils;
import keycloakjar.org.apache.hc.core5.reactor.IOReactorConfig;
import keycloakjar.org.apache.hc.core5.reactor.IOSession;
import keycloakjar.org.apache.hc.core5.reactor.IOSessionListener;
import keycloakjar.org.apache.hc.core5.util.Args;
import keycloakjar.org.apache.hc.core5.util.Timeout;

public class AsyncServerBootstrap {
    private final List<HandlerEntry<Supplier<AsyncServerExchangeHandler>>> handlerList = new ArrayList<HandlerEntry<Supplier<AsyncServerExchangeHandler>>>();
    private final List<FilterEntry<AsyncFilterHandler>> filters = new ArrayList<FilterEntry<AsyncFilterHandler>>();
    private String canonicalHostName;
    private LookupRegistry<Supplier<AsyncServerExchangeHandler>> lookupRegistry;
    private IOReactorConfig ioReactorConfig;
    private Http1Config http1Config;
    private CharCodingConfig charCodingConfig;
    private HttpProcessor httpProcessor;
    private ConnectionReuseStrategy connStrategy;
    private TlsStrategy tlsStrategy;
    private Timeout handshakeTimeout;
    private Decorator<IOSession> ioSessionDecorator;
    private Callback<Exception> exceptionCallback;
    private IOSessionListener sessionListener;
    private Http1StreamListener streamListener;

    private AsyncServerBootstrap() {
    }

    public static AsyncServerBootstrap bootstrap() {
        return new AsyncServerBootstrap();
    }

    public final AsyncServerBootstrap setCanonicalHostName(String canonicalHostName) {
        this.canonicalHostName = canonicalHostName;
        return this;
    }

    public final AsyncServerBootstrap setIOReactorConfig(IOReactorConfig ioReactorConfig) {
        this.ioReactorConfig = ioReactorConfig;
        return this;
    }

    public final AsyncServerBootstrap setHttp1Config(Http1Config http1Config) {
        this.http1Config = http1Config;
        return this;
    }

    public final AsyncServerBootstrap setCharCodingConfig(CharCodingConfig charCodingConfig) {
        this.charCodingConfig = charCodingConfig;
        return this;
    }

    public final AsyncServerBootstrap setHttpProcessor(HttpProcessor httpProcessor) {
        this.httpProcessor = httpProcessor;
        return this;
    }

    public final AsyncServerBootstrap setConnectionReuseStrategy(ConnectionReuseStrategy connStrategy) {
        this.connStrategy = connStrategy;
        return this;
    }

    public final AsyncServerBootstrap setTlsStrategy(TlsStrategy tlsStrategy) {
        this.tlsStrategy = tlsStrategy;
        return this;
    }

    public final AsyncServerBootstrap setTlsHandshakeTimeout(Timeout handshakeTimeout) {
        this.handshakeTimeout = handshakeTimeout;
        return this;
    }

    public final AsyncServerBootstrap setIOSessionDecorator(Decorator<IOSession> ioSessionDecorator) {
        this.ioSessionDecorator = ioSessionDecorator;
        return this;
    }

    public final AsyncServerBootstrap setExceptionCallback(Callback<Exception> exceptionCallback) {
        this.exceptionCallback = exceptionCallback;
        return this;
    }

    public final AsyncServerBootstrap setIOSessionListener(IOSessionListener sessionListener) {
        this.sessionListener = sessionListener;
        return this;
    }

    public final AsyncServerBootstrap setLookupRegistry(LookupRegistry<Supplier<AsyncServerExchangeHandler>> lookupRegistry) {
        this.lookupRegistry = lookupRegistry;
        return this;
    }

    public final AsyncServerBootstrap setStreamListener(Http1StreamListener streamListener) {
        this.streamListener = streamListener;
        return this;
    }

    public final AsyncServerBootstrap register(String uriPattern, Supplier<AsyncServerExchangeHandler> supplier) {
        Args.notBlank(uriPattern, "URI pattern");
        Args.notNull(supplier, "Supplier");
        this.handlerList.add(new HandlerEntry<Supplier<AsyncServerExchangeHandler>>(null, uriPattern, supplier));
        return this;
    }

    public final AsyncServerBootstrap registerVirtual(String hostname, String uriPattern, Supplier<AsyncServerExchangeHandler> supplier) {
        Args.notBlank(hostname, "Hostname");
        Args.notBlank(uriPattern, "URI pattern");
        Args.notNull(supplier, "Supplier");
        this.handlerList.add(new HandlerEntry<Supplier<AsyncServerExchangeHandler>>(hostname, uriPattern, supplier));
        return this;
    }

    public final <T> AsyncServerBootstrap register(String uriPattern, AsyncServerRequestHandler<T> requestHandler) {
        this.register(uriPattern, () -> new BasicServerExchangeHandler(requestHandler));
        return this;
    }

    public final <T> AsyncServerBootstrap registerVirtual(String hostname, String uriPattern, AsyncServerRequestHandler<T> requestHandler) {
        this.registerVirtual(hostname, uriPattern, () -> new BasicServerExchangeHandler(requestHandler));
        return this;
    }

    public final AsyncServerBootstrap addFilterBefore(String existing, String name, AsyncFilterHandler filterHandler) {
        Args.notBlank(existing, "Existing");
        Args.notBlank(name, "Name");
        Args.notNull(filterHandler, "Filter handler");
        this.filters.add(new FilterEntry<AsyncFilterHandler>(FilterEntry.Position.BEFORE, name, filterHandler, existing));
        return this;
    }

    public final AsyncServerBootstrap addFilterAfter(String existing, String name, AsyncFilterHandler filterHandler) {
        Args.notBlank(existing, "Existing");
        Args.notBlank(name, "Name");
        Args.notNull(filterHandler, "Filter handler");
        this.filters.add(new FilterEntry<AsyncFilterHandler>(FilterEntry.Position.AFTER, name, filterHandler, existing));
        return this;
    }

    public final AsyncServerBootstrap replaceFilter(String existing, AsyncFilterHandler filterHandler) {
        Args.notBlank(existing, "Existing");
        Args.notNull(filterHandler, "Filter handler");
        this.filters.add(new FilterEntry<AsyncFilterHandler>(FilterEntry.Position.REPLACE, existing, filterHandler, existing));
        return this;
    }

    public final AsyncServerBootstrap addFilterFirst(String name, AsyncFilterHandler filterHandler) {
        Args.notNull(name, "Name");
        Args.notNull(filterHandler, "Filter handler");
        this.filters.add(new FilterEntry<AsyncFilterHandler>(FilterEntry.Position.FIRST, name, filterHandler, null));
        return this;
    }

    public final AsyncServerBootstrap addFilterLast(String name, AsyncFilterHandler filterHandler) {
        Args.notNull(name, "Name");
        Args.notNull(filterHandler, "Filter handler");
        this.filters.add(new FilterEntry<AsyncFilterHandler>(FilterEntry.Position.LAST, name, filterHandler, null));
        return this;
    }

    public HttpAsyncServer create() {
        HandlerFactory<AsyncServerExchangeHandler> handlerFactory;
        RequestHandlerRegistry<Supplier<AsyncServerExchangeHandler>> registry = new RequestHandlerRegistry<Supplier<AsyncServerExchangeHandler>>(this.canonicalHostName != null ? this.canonicalHostName : InetAddressUtils.getCanonicalLocalHostName(), () -> this.lookupRegistry != null ? this.lookupRegistry : UriPatternType.newMatcher(UriPatternType.URI_PATTERN));
        for (HandlerEntry<Supplier<AsyncServerExchangeHandler>> entry : this.handlerList) {
            registry.register(entry.hostname, entry.uriPattern, (Supplier<AsyncServerExchangeHandler>)entry.handler);
        }
        if (!this.filters.isEmpty()) {
            NamedElementChain<AsyncFilterHandler> filterChainDefinition = new NamedElementChain<AsyncFilterHandler>();
            filterChainDefinition.addLast(new TerminalAsyncServerFilter(new DefaultAsyncResponseExchangeHandlerFactory(registry)), StandardFilter.MAIN_HANDLER.name());
            filterChainDefinition.addFirst(new AsyncServerExpectationFilter(), StandardFilter.EXPECT_CONTINUE.name());
            for (FilterEntry<AsyncFilterHandler> entry : this.filters) {
                switch (entry.position) {
                    case AFTER: {
                        filterChainDefinition.addAfter(entry.existing, (AsyncFilterHandler)entry.filterHandler, entry.name);
                        break;
                    }
                    case BEFORE: {
                        filterChainDefinition.addBefore(entry.existing, (AsyncFilterHandler)entry.filterHandler, entry.name);
                        break;
                    }
                    case REPLACE: {
                        filterChainDefinition.replace(entry.existing, (AsyncFilterHandler)entry.filterHandler);
                        break;
                    }
                    case FIRST: {
                        filterChainDefinition.addFirst((AsyncFilterHandler)entry.filterHandler, entry.name);
                        break;
                    }
                    case LAST: {
                        filterChainDefinition.addBefore(StandardFilter.MAIN_HANDLER.name(), (AsyncFilterHandler)entry.filterHandler, entry.name);
                    }
                }
            }
            AsyncServerFilterChainElement execChain = null;
            for (NamedElementChain.Node current = filterChainDefinition.getLast(); current != null; current = current.getPrevious()) {
                execChain = new AsyncServerFilterChainElement((AsyncFilterHandler)current.getValue(), execChain);
            }
            handlerFactory = new AsyncServerFilterChainExchangeHandlerFactory(execChain, this.exceptionCallback);
        } else {
            handlerFactory = new DefaultAsyncResponseExchangeHandlerFactory(registry, handler -> new BasicAsyncServerExpectationDecorator((AsyncServerExchangeHandler)handler, this.exceptionCallback));
        }
        ServerHttp1StreamDuplexerFactory streamHandlerFactory = new ServerHttp1StreamDuplexerFactory(this.httpProcessor != null ? this.httpProcessor : HttpProcessors.server(), handlerFactory, this.http1Config != null ? this.http1Config : Http1Config.DEFAULT, this.charCodingConfig != null ? this.charCodingConfig : CharCodingConfig.DEFAULT, this.connStrategy != null ? this.connStrategy : DefaultConnectionReuseStrategy.INSTANCE, DefaultHttpRequestParserFactory.INSTANCE, DefaultHttpResponseWriterFactory.INSTANCE, DefaultContentLengthStrategy.INSTANCE, DefaultContentLengthStrategy.INSTANCE, this.streamListener);
        ServerHttp1IOEventHandlerFactory ioEventHandlerFactory = new ServerHttp1IOEventHandlerFactory(streamHandlerFactory, this.tlsStrategy, this.handshakeTimeout);
        return new HttpAsyncServer(ioEventHandlerFactory, this.ioReactorConfig, this.ioSessionDecorator, this.exceptionCallback, this.sessionListener);
    }
}

