/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.apache.hc.core5.http.impl.nio;

import keycloakjar.org.apache.hc.core5.annotation.Contract;
import keycloakjar.org.apache.hc.core5.annotation.ThreadingBehavior;
import keycloakjar.org.apache.hc.core5.http.HttpResponse;
import keycloakjar.org.apache.hc.core5.http.HttpResponseFactory;
import keycloakjar.org.apache.hc.core5.http.ReasonPhraseCatalog;
import keycloakjar.org.apache.hc.core5.http.impl.EnglishReasonPhraseCatalog;
import keycloakjar.org.apache.hc.core5.http.message.BasicHttpResponse;
import keycloakjar.org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpResponseFactory
implements HttpResponseFactory<HttpResponse> {
    public static final DefaultHttpResponseFactory INSTANCE = new DefaultHttpResponseFactory();
    private final ReasonPhraseCatalog reasonCatalog;

    public DefaultHttpResponseFactory(ReasonPhraseCatalog catalog) {
        this.reasonCatalog = Args.notNull(catalog, "Reason phrase catalog");
    }

    public DefaultHttpResponseFactory() {
        this(EnglishReasonPhraseCatalog.INSTANCE);
    }

    @Override
    public HttpResponse newHttpResponse(int status, String reasonPhrase) {
        return new BasicHttpResponse(status, reasonPhrase);
    }

    @Override
    public HttpResponse newHttpResponse(int status) {
        return new BasicHttpResponse(status, this.reasonCatalog, null);
    }
}

