/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.apache.hc.core5.http.nio.support;

import java.io.IOException;
import keycloakjar.org.apache.hc.core5.annotation.Contract;
import keycloakjar.org.apache.hc.core5.annotation.ThreadingBehavior;
import keycloakjar.org.apache.hc.core5.http.EntityDetails;
import keycloakjar.org.apache.hc.core5.http.Header;
import keycloakjar.org.apache.hc.core5.http.HttpException;
import keycloakjar.org.apache.hc.core5.http.HttpRequest;
import keycloakjar.org.apache.hc.core5.http.HttpResponse;
import keycloakjar.org.apache.hc.core5.http.message.BasicHttpResponse;
import keycloakjar.org.apache.hc.core5.http.nio.AsyncDataConsumer;
import keycloakjar.org.apache.hc.core5.http.nio.AsyncEntityProducer;
import keycloakjar.org.apache.hc.core5.http.nio.AsyncFilterChain;
import keycloakjar.org.apache.hc.core5.http.nio.AsyncFilterHandler;
import keycloakjar.org.apache.hc.core5.http.protocol.HttpContext;

@Contract(threading=ThreadingBehavior.STATELESS)
public class AsyncServerExpectationFilter
implements AsyncFilterHandler {
    protected boolean verify(HttpRequest request, HttpContext context) throws HttpException {
        return true;
    }

    protected AsyncEntityProducer generateResponseContent(HttpResponse expectationFailed) throws HttpException {
        return null;
    }

    @Override
    public final AsyncDataConsumer handle(HttpRequest request, EntityDetails entityDetails, HttpContext context, AsyncFilterChain.ResponseTrigger responseTrigger, AsyncFilterChain chain) throws HttpException, IOException {
        Header h2;
        if (entityDetails != null && (h2 = request.getFirstHeader("Expect")) != null && "100-continue".equalsIgnoreCase(h2.getValue())) {
            boolean verified = this.verify(request, context);
            if (verified) {
                responseTrigger.sendInformation(new BasicHttpResponse(100));
            } else {
                BasicHttpResponse expectationFailed = new BasicHttpResponse(417);
                AsyncEntityProducer responseContentProducer = this.generateResponseContent(expectationFailed);
                responseTrigger.submitResponse(expectationFailed, responseContentProducer);
                return null;
            }
        }
        return chain.proceed(request, entityDetails, context, responseTrigger);
    }
}

