/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.apache.hc.core5.http.protocol;

import java.io.IOException;
import keycloakjar.org.apache.hc.core5.annotation.Contract;
import keycloakjar.org.apache.hc.core5.annotation.ThreadingBehavior;
import keycloakjar.org.apache.hc.core5.http.EntityDetails;
import keycloakjar.org.apache.hc.core5.http.HttpException;
import keycloakjar.org.apache.hc.core5.http.HttpRequest;
import keycloakjar.org.apache.hc.core5.http.HttpRequestInterceptor;
import keycloakjar.org.apache.hc.core5.http.HttpVersion;
import keycloakjar.org.apache.hc.core5.http.ProtocolVersion;
import keycloakjar.org.apache.hc.core5.http.protocol.HttpContext;
import keycloakjar.org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    public static final RequestExpectContinue INSTANCE = new RequestExpectContinue();

    @Override
    public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && entity != null) {
            ProtocolVersion ver = context.getProtocolVersion();
            if (entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0)) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

