/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.apache.hc.core5.http2.impl;

import keycloakjar.org.apache.hc.core5.http.impl.HttpProcessors;
import keycloakjar.org.apache.hc.core5.http.protocol.HttpProcessor;
import keycloakjar.org.apache.hc.core5.http.protocol.HttpProcessorBuilder;
import keycloakjar.org.apache.hc.core5.http.protocol.RequestExpectContinue;
import keycloakjar.org.apache.hc.core5.http.protocol.RequestUserAgent;
import keycloakjar.org.apache.hc.core5.http.protocol.ResponseDate;
import keycloakjar.org.apache.hc.core5.http.protocol.ResponseServer;
import keycloakjar.org.apache.hc.core5.http2.protocol.H2RequestConnControl;
import keycloakjar.org.apache.hc.core5.http2.protocol.H2RequestContent;
import keycloakjar.org.apache.hc.core5.http2.protocol.H2RequestTargetHost;
import keycloakjar.org.apache.hc.core5.http2.protocol.H2RequestValidateHost;
import keycloakjar.org.apache.hc.core5.http2.protocol.H2ResponseConnControl;
import keycloakjar.org.apache.hc.core5.http2.protocol.H2ResponseContent;
import keycloakjar.org.apache.hc.core5.util.TextUtils;
import keycloakjar.org.apache.hc.core5.util.VersionInfo;

public final class H2Processors {
    private static final String SOFTWARE = "Apache-HttpCore";

    public static HttpProcessorBuilder customServer(String serverInfo) {
        return HttpProcessorBuilder.create().addAll(new ResponseDate(), new ResponseServer(!TextUtils.isBlank(serverInfo) ? serverInfo : VersionInfo.getSoftwareInfo(SOFTWARE, "keycloakjar.org.apache.hc.core5", H2Processors.class)), H2ResponseContent.INSTANCE, H2ResponseConnControl.INSTANCE).addAll(H2RequestValidateHost.INSTANCE);
    }

    public static HttpProcessor server(String serverInfo) {
        return H2Processors.customServer(serverInfo).build();
    }

    public static HttpProcessor server() {
        return H2Processors.customServer(null).build();
    }

    public static HttpProcessorBuilder customClient(String agentInfo) {
        return HttpProcessorBuilder.create().addAll(H2RequestContent.INSTANCE, H2RequestTargetHost.INSTANCE, H2RequestConnControl.INSTANCE, new RequestUserAgent(!TextUtils.isBlank(agentInfo) ? agentInfo : VersionInfo.getSoftwareInfo(SOFTWARE, "keycloakjar.org.apache.hc.core5", HttpProcessors.class)), RequestExpectContinue.INSTANCE);
    }

    public static HttpProcessor client(String agentInfo) {
        return H2Processors.customClient(agentInfo).build();
    }

    public static HttpProcessor client() {
        return H2Processors.customClient(null).build();
    }
}

