/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.beans;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import keycloakjar.org.springframework.beans.BeanInfoFactory;
import keycloakjar.org.springframework.core.Ordered;
import keycloakjar.org.springframework.core.SpringProperties;
import keycloakjar.org.springframework.lang.NonNull;

public class StandardBeanInfoFactory
implements BeanInfoFactory,
Ordered {
    public static final String IGNORE_BEANINFO_PROPERTY_NAME = "spring.beaninfo.ignore";
    private static final boolean shouldIntrospectorIgnoreBeaninfoClasses = SpringProperties.getFlag("spring.beaninfo.ignore");

    @Override
    @NonNull
    public BeanInfo getBeanInfo(Class<?> beanClass) throws IntrospectionException {
        BeanInfo beanInfo = shouldIntrospectorIgnoreBeaninfoClasses ? Introspector.getBeanInfo(beanClass, 3) : Introspector.getBeanInfo(beanClass);
        Class<?> classToFlush = beanClass;
        do {
            Introspector.flushFromCaches(classToFlush);
        } while ((classToFlush = classToFlush.getSuperclass()) != null && classToFlush != Object.class);
        return beanInfo;
    }

    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

