/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.beans.factory.config;

import java.lang.reflect.InvocationTargetException;
import keycloakjar.org.springframework.beans.TypeConverter;
import keycloakjar.org.springframework.beans.factory.BeanClassLoaderAware;
import keycloakjar.org.springframework.beans.factory.BeanFactory;
import keycloakjar.org.springframework.beans.factory.BeanFactoryAware;
import keycloakjar.org.springframework.beans.factory.InitializingBean;
import keycloakjar.org.springframework.beans.factory.config.ConfigurableBeanFactory;
import keycloakjar.org.springframework.beans.support.ArgumentConvertingMethodInvoker;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.ClassUtils;

public class MethodInvokingBean
extends ArgumentConvertingMethodInvoker
implements BeanClassLoaderAware,
BeanFactoryAware,
InitializingBean {
    @Nullable
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    @Nullable
    private ConfigurableBeanFactory beanFactory;

    @Override
    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    @Override
    protected Class<?> resolveClassName(String className) throws ClassNotFoundException {
        return ClassUtils.forName(className, this.beanClassLoader);
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        if (beanFactory instanceof ConfigurableBeanFactory) {
            ConfigurableBeanFactory cbf;
            this.beanFactory = cbf = (ConfigurableBeanFactory)beanFactory;
        }
    }

    @Override
    protected TypeConverter getDefaultTypeConverter() {
        if (this.beanFactory != null) {
            return this.beanFactory.getTypeConverter();
        }
        return super.getDefaultTypeConverter();
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        this.prepare();
        this.invokeWithTargetException();
    }

    @Nullable
    protected Object invokeWithTargetException() throws Exception {
        try {
            return this.invoke();
        }
        catch (InvocationTargetException ex) {
            Throwable throwable = ex.getTargetException();
            if (throwable instanceof Exception) {
                Exception exception = (Exception)throwable;
                throw exception;
            }
            throwable = ex.getTargetException();
            if (throwable instanceof Error) {
                Error error = (Error)throwable;
                throw error;
            }
            throw ex;
        }
    }
}

