/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.cglib.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import keycloakjar.org.springframework.cglib.core.Predicate;
import keycloakjar.org.springframework.cglib.core.Transformer;

public class CollectionUtils {
    private CollectionUtils() {
    }

    public static Map bucket(Collection c, Transformer t2) {
        HashMap buckets = new HashMap();
        for (Object value : c) {
            Object key = t2.transform(value);
            LinkedList bucket = (LinkedList)buckets.get(key);
            if (bucket == null) {
                bucket = new LinkedList();
                buckets.put(key, bucket);
            }
            bucket.add(value);
        }
        return buckets;
    }

    public static void reverse(Map source, Map target) {
        for (Object key : source.keySet()) {
            target.put(source.get(key), key);
        }
    }

    public static Collection filter(Collection c, Predicate p) {
        c.removeIf(o -> !p.evaluate(o));
        return c;
    }

    public static List transform(Collection c, Transformer t2) {
        ArrayList<Object> result = new ArrayList<Object>(c.size());
        Iterator it = c.iterator();
        while (it.hasNext()) {
            result.add(t2.transform(it.next()));
        }
        return result;
    }

    public static Map getIndexMap(List list) {
        HashMap indexes = new HashMap();
        int index = 0;
        Iterator it = list.iterator();
        while (it.hasNext()) {
            indexes.put(it.next(), index++);
        }
        return indexes;
    }
}

