/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.core.codec;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import keycloakjar.org.springframework.core.ResolvableType;
import keycloakjar.org.springframework.core.codec.CodecException;
import keycloakjar.org.springframework.core.codec.DecodingException;
import keycloakjar.org.springframework.core.io.buffer.DataBuffer;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;
import keycloakjar.org.springframework.util.MimeType;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface Decoder<T> {
    public boolean canDecode(ResolvableType var1, @Nullable MimeType var2);

    public Flux<T> decode(Publisher<DataBuffer> var1, ResolvableType var2, @Nullable MimeType var3, @Nullable Map<String, Object> var4);

    public Mono<T> decodeToMono(Publisher<DataBuffer> var1, ResolvableType var2, @Nullable MimeType var3, @Nullable Map<String, Object> var4);

    @Nullable
    default public T decode(DataBuffer buffer, ResolvableType targetType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) throws DecodingException {
        CompletableFuture future = this.decodeToMono((Publisher<DataBuffer>)Mono.just((Object)buffer), targetType, mimeType, hints).toFuture();
        Assert.state(future.isDone(), "DataBuffer decoding should have completed");
        try {
            return future.get();
        }
        catch (ExecutionException ex) {
            CodecException codecException;
            Throwable cause = ex.getCause();
            if (cause instanceof CodecException) {
                CodecException codecException2 = (CodecException)cause;
                codecException = codecException2;
            } else {
                codecException = new DecodingException("Failed to decode: " + (Serializable)(cause != null ? cause.getMessage() : ex), cause);
            }
            throw codecException;
        }
        catch (InterruptedException ex) {
            throw new DecodingException("Interrupted during decode", ex);
        }
    }

    public List<MimeType> getDecodableMimeTypes();

    default public List<MimeType> getDecodableMimeTypes(ResolvableType targetType) {
        return this.canDecode(targetType, null) ? this.getDecodableMimeTypes() : Collections.emptyList();
    }
}

