/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.core.codec;

import java.nio.charset.Charset;
import java.util.List;
import keycloakjar.org.springframework.core.ResolvableType;
import keycloakjar.org.springframework.core.codec.AbstractCharSequenceDecoder;
import keycloakjar.org.springframework.core.io.buffer.DataBuffer;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.MimeType;
import keycloakjar.org.springframework.util.MimeTypeUtils;

public final class StringDecoder
extends AbstractCharSequenceDecoder<String> {
    private StringDecoder(List<String> delimiters, boolean stripDelimiter, MimeType ... mimeTypes) {
        super(delimiters, stripDelimiter, mimeTypes);
    }

    @Override
    public boolean canDecode(ResolvableType elementType, @Nullable MimeType mimeType) {
        return elementType.resolve() == String.class && super.canDecode(elementType, mimeType);
    }

    @Override
    protected String decodeInternal(DataBuffer dataBuffer, Charset charset) {
        return dataBuffer.toString(charset);
    }

    public static StringDecoder textPlainOnly() {
        return StringDecoder.textPlainOnly(DEFAULT_DELIMITERS, true);
    }

    public static StringDecoder textPlainOnly(List<String> delimiters, boolean stripDelimiter) {
        return new StringDecoder(delimiters, stripDelimiter, new MimeType("text", "plain", DEFAULT_CHARSET));
    }

    public static StringDecoder allMimeTypes() {
        return StringDecoder.allMimeTypes(DEFAULT_DELIMITERS, true);
    }

    public static StringDecoder allMimeTypes(List<String> delimiters, boolean stripDelimiter) {
        return new StringDecoder(delimiters, stripDelimiter, new MimeType("text", "plain", DEFAULT_CHARSET), MimeTypeUtils.ALL);
    }
}

