/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.core.convert.support;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import keycloakjar.org.springframework.core.convert.ConversionService;
import keycloakjar.org.springframework.core.convert.TypeDescriptor;
import keycloakjar.org.springframework.core.convert.converter.ConditionalGenericConverter;
import keycloakjar.org.springframework.core.convert.converter.GenericConverter;
import keycloakjar.org.springframework.core.convert.support.CollectionToArrayConverter;
import keycloakjar.org.springframework.core.convert.support.GenericConversionService;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.ObjectUtils;

final class ArrayToArrayConverter
implements ConditionalGenericConverter {
    private final CollectionToArrayConverter helperConverter;
    private final ConversionService conversionService;

    public ArrayToArrayConverter(ConversionService conversionService) {
        this.helperConverter = new CollectionToArrayConverter(conversionService);
        this.conversionService = conversionService;
    }

    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Object[].class, Object[].class));
    }

    @Override
    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return this.helperConverter.matches(sourceType, targetType);
    }

    @Override
    @Nullable
    public Object convert(@Nullable Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        ConversionService conversionService = this.conversionService;
        if (conversionService instanceof GenericConversionService) {
            GenericConversionService genericConversionService = (GenericConversionService)conversionService;
            TypeDescriptor targetElement = targetType.getElementTypeDescriptor();
            if (targetElement != null && genericConversionService.canBypassConvert(sourceType.getElementTypeDescriptor(), targetElement)) {
                return source;
            }
        }
        List<Object> sourceList = Arrays.asList(ObjectUtils.toObjectArray(source));
        return this.helperConverter.convert(sourceList, sourceType, targetType);
    }
}

