/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http.client;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import keycloakjar.org.springframework.http.HttpHeaders;
import keycloakjar.org.springframework.http.HttpMethod;
import keycloakjar.org.springframework.http.StreamingHttpOutputMessage;
import keycloakjar.org.springframework.http.client.AbstractBufferingClientHttpRequest;
import keycloakjar.org.springframework.http.client.BufferingClientHttpResponseWrapper;
import keycloakjar.org.springframework.http.client.ClientHttpRequest;
import keycloakjar.org.springframework.http.client.ClientHttpResponse;
import keycloakjar.org.springframework.util.StreamUtils;

final class BufferingClientHttpRequestWrapper
extends AbstractBufferingClientHttpRequest {
    private final ClientHttpRequest request;

    BufferingClientHttpRequestWrapper(ClientHttpRequest request) {
        this.request = request;
    }

    @Override
    public HttpMethod getMethod() {
        return this.request.getMethod();
    }

    @Override
    public URI getURI() {
        return this.request.getURI();
    }

    @Override
    protected ClientHttpResponse executeInternal(HttpHeaders headers, final byte[] bufferedOutput) throws IOException {
        this.request.getHeaders().putAll(headers);
        if (bufferedOutput.length > 0) {
            ClientHttpRequest clientHttpRequest = this.request;
            if (clientHttpRequest instanceof StreamingHttpOutputMessage) {
                StreamingHttpOutputMessage streamingHttpOutputMessage = (StreamingHttpOutputMessage)((Object)clientHttpRequest);
                streamingHttpOutputMessage.setBody(new StreamingHttpOutputMessage.Body(){

                    @Override
                    public void writeTo(OutputStream outputStream) throws IOException {
                        StreamUtils.copy(bufferedOutput, outputStream);
                    }

                    @Override
                    public boolean repeatable() {
                        return true;
                    }
                });
            } else {
                StreamUtils.copy(bufferedOutput, this.request.getBody());
            }
        }
        ClientHttpResponse response = this.request.execute();
        return new BufferingClientHttpResponseWrapper(response);
    }
}

