/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http.client;

import java.io.IOException;
import java.io.InputStream;
import keycloakjar.org.springframework.http.HttpHeaders;
import keycloakjar.org.springframework.http.HttpStatusCode;
import keycloakjar.org.springframework.http.client.ClientHttpResponse;
import keycloakjar.org.springframework.http.support.JettyHeadersAdapter;
import org.eclipse.jetty.client.Response;

class JettyClientHttpResponse
implements ClientHttpResponse {
    private final Response response;
    private final InputStream body;
    private final HttpHeaders headers;

    public JettyClientHttpResponse(Response response, InputStream inputStream) {
        this.response = response;
        this.body = inputStream;
        JettyHeadersAdapter headers = new JettyHeadersAdapter(response.getHeaders());
        this.headers = HttpHeaders.readOnlyHttpHeaders(headers);
    }

    @Override
    public HttpStatusCode getStatusCode() throws IOException {
        return HttpStatusCode.valueOf(this.response.getStatus());
    }

    @Override
    public String getStatusText() throws IOException {
        return this.response.getReason();
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public InputStream getBody() throws IOException {
        return this.body;
    }

    @Override
    public void close() {
        try {
            this.body.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

