/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http.client;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;

final class OutputStreamPublisher<T>
implements Flow.Publisher<T> {
    private static final int DEFAULT_CHUNK_SIZE = 1024;
    private final OutputStreamHandler outputStreamHandler;
    private final ByteMapper<T> byteMapper;
    private final Executor executor;
    private final int chunkSize;

    private OutputStreamPublisher(OutputStreamHandler outputStreamHandler, ByteMapper<T> byteMapper, Executor executor, int chunkSize) {
        this.outputStreamHandler = outputStreamHandler;
        this.byteMapper = byteMapper;
        this.executor = executor;
        this.chunkSize = chunkSize;
    }

    public static <T> Flow.Publisher<T> create(OutputStreamHandler outputStreamHandler, ByteMapper<T> byteMapper, Executor executor) {
        Assert.notNull((Object)outputStreamHandler, "OutputStreamHandler must not be null");
        Assert.notNull(byteMapper, "ByteMapper must not be null");
        Assert.notNull((Object)executor, "Executor must not be null");
        return new OutputStreamPublisher<T>(outputStreamHandler, byteMapper, executor, 1024);
    }

    public static <T> Flow.Publisher<T> create(OutputStreamHandler outputStreamHandler, ByteMapper<T> byteMapper, Executor executor, int chunkSize) {
        Assert.notNull((Object)outputStreamHandler, "OutputStreamHandler must not be null");
        Assert.notNull(byteMapper, "ByteMapper must not be null");
        Assert.notNull((Object)executor, "Executor must not be null");
        Assert.isTrue(chunkSize > 0, "ChunkSize must be larger than 0");
        return new OutputStreamPublisher<T>(outputStreamHandler, byteMapper, executor, chunkSize);
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        Objects.requireNonNull(subscriber, "Subscriber must not be null");
        OutputStreamSubscription<? super T> subscription = new OutputStreamSubscription<T>(subscriber, this.outputStreamHandler, this.byteMapper, this.chunkSize);
        subscriber.onSubscribe(subscription);
        this.executor.execute(subscription::invokeHandler);
    }

    @FunctionalInterface
    public static interface OutputStreamHandler {
        public void handle(OutputStream var1) throws IOException;
    }

    public static interface ByteMapper<T> {
        public T map(int var1);

        public T map(byte[] var1, int var2, int var3);
    }

    private static final class OutputStreamSubscription<T>
    extends OutputStream
    implements Flow.Subscription {
        static final Object READY = new Object();
        private final Flow.Subscriber<? super T> actual;
        private final OutputStreamHandler outputStreamHandler;
        private final ByteMapper<T> byteMapper;
        private final int chunkSize;
        private final AtomicLong requested = new AtomicLong();
        private final AtomicReference<Object> parkedThread = new AtomicReference();
        @Nullable
        private volatile Throwable error;
        private long produced;

        public OutputStreamSubscription(Flow.Subscriber<? super T> actual, OutputStreamHandler outputStreamHandler, ByteMapper<T> byteMapper, int chunkSize) {
            this.actual = actual;
            this.byteMapper = byteMapper;
            this.outputStreamHandler = outputStreamHandler;
            this.chunkSize = chunkSize;
        }

        @Override
        public void write(int b) throws IOException {
            this.checkDemandAndAwaitIfNeeded();
            T next = this.byteMapper.map(b);
            this.actual.onNext(next);
            ++this.produced;
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.checkDemandAndAwaitIfNeeded();
            T next = this.byteMapper.map(b, off, len);
            this.actual.onNext(next);
            ++this.produced;
        }

        private void checkDemandAndAwaitIfNeeded() throws IOException {
            long r = this.requested.get();
            if (OutputStreamSubscription.isTerminated(r) || OutputStreamSubscription.isCancelled(r)) {
                throw new IOException("Subscription has been terminated");
            }
            long p = this.produced;
            if (p == r) {
                if (p > 0L) {
                    r = this.tryProduce(p);
                    this.produced = 0L;
                }
                while (true) {
                    if (OutputStreamSubscription.isTerminated(r) || OutputStreamSubscription.isCancelled(r)) {
                        throw new IOException("Subscription has been terminated");
                    }
                    if (r != 0L) {
                        return;
                    }
                    this.await();
                    r = this.requested.get();
                }
            }
        }

        private void invokeHandler() {
            try (BufferedOutputStream outputStream = new BufferedOutputStream(this, this.chunkSize);){
                this.outputStreamHandler.handle(outputStream);
            }
            catch (IOException ex) {
                long previousState = this.tryTerminate();
                if (OutputStreamSubscription.isCancelled(previousState)) {
                    return;
                }
                if (OutputStreamSubscription.isTerminated(previousState)) {
                    this.actual.onError(this.error);
                    return;
                }
                this.actual.onError(ex);
                return;
            }
            long previousState = this.tryTerminate();
            if (OutputStreamSubscription.isCancelled(previousState)) {
                return;
            }
            if (OutputStreamSubscription.isTerminated(previousState)) {
                this.actual.onError(this.error);
                return;
            }
            this.actual.onComplete();
        }

        @Override
        public void request(long n) {
            if (n <= 0L) {
                this.error = new IllegalArgumentException("request should be a positive number");
                long previousState = this.tryTerminate();
                if (OutputStreamSubscription.isTerminated(previousState) || OutputStreamSubscription.isCancelled(previousState)) {
                    return;
                }
                if (previousState > 0L) {
                    return;
                }
                this.resume();
                return;
            }
            if (this.addCap(n) == 0L) {
                this.resume();
            }
        }

        @Override
        public void cancel() {
            long previousState = this.tryCancel();
            if (OutputStreamSubscription.isCancelled(previousState) || previousState > 0L) {
                return;
            }
            this.resume();
        }

        private void await() {
            Object current;
            Thread toUnpark = Thread.currentThread();
            while ((current = this.parkedThread.get()) != READY) {
                if (current != null && current != toUnpark) {
                    throw new IllegalStateException("Only one (Virtual)Thread can await!");
                }
                if (!this.parkedThread.compareAndSet(null, toUnpark)) continue;
                LockSupport.park();
            }
            this.parkedThread.lazySet(null);
        }

        private void resume() {
            Object old;
            if (this.parkedThread.get() != READY && (old = this.parkedThread.getAndSet(READY)) != READY) {
                LockSupport.unpark((Thread)old);
            }
        }

        private long tryCancel() {
            long r;
            do {
                if (!OutputStreamSubscription.isCancelled(r = this.requested.get())) continue;
                return r;
            } while (!this.requested.compareAndSet(r, Long.MIN_VALUE));
            return r;
        }

        private long tryTerminate() {
            long r;
            do {
                if (!OutputStreamSubscription.isCancelled(r = this.requested.get()) && !OutputStreamSubscription.isTerminated(r)) continue;
                return r;
            } while (!this.requested.compareAndSet(r, -1L));
            return r;
        }

        private long tryProduce(long n) {
            long update;
            long current;
            do {
                if (OutputStreamSubscription.isTerminated(current = this.requested.get()) || OutputStreamSubscription.isCancelled(current)) {
                    return current;
                }
                if (current == Long.MAX_VALUE) {
                    return Long.MAX_VALUE;
                }
                update = current - n;
                if (update >= 0L) continue;
                update = 0L;
            } while (!this.requested.compareAndSet(current, update));
            return update;
        }

        private long addCap(long n) {
            long u;
            long r;
            do {
                if (!OutputStreamSubscription.isTerminated(r = this.requested.get()) && !OutputStreamSubscription.isCancelled(r) && r != Long.MAX_VALUE) continue;
                return r;
            } while (!this.requested.compareAndSet(r, u = OutputStreamSubscription.addCap(r, n)));
            return r;
        }

        private static boolean isTerminated(long state) {
            return state == -1L;
        }

        private static boolean isCancelled(long state) {
            return state == Long.MIN_VALUE;
        }

        private static long addCap(long a, long b) {
            long res = a + b;
            if (res < 0L) {
                return Long.MAX_VALUE;
            }
            return res;
        }
    }
}

