/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http.converter;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import keycloakjar.org.springframework.http.HttpHeaders;
import keycloakjar.org.springframework.http.HttpOutputMessage;
import keycloakjar.org.springframework.http.MediaType;
import keycloakjar.org.springframework.http.StreamingHttpOutputMessage;
import keycloakjar.org.springframework.http.converter.AbstractHttpMessageConverter;
import keycloakjar.org.springframework.http.converter.GenericHttpMessageConverter;
import keycloakjar.org.springframework.http.converter.HttpMessageNotWritableException;
import keycloakjar.org.springframework.lang.Nullable;

public abstract class AbstractGenericHttpMessageConverter<T>
extends AbstractHttpMessageConverter<T>
implements GenericHttpMessageConverter<T> {
    protected AbstractGenericHttpMessageConverter() {
    }

    protected AbstractGenericHttpMessageConverter(MediaType supportedMediaType) {
        super(supportedMediaType);
    }

    protected AbstractGenericHttpMessageConverter(MediaType ... supportedMediaTypes) {
        super(supportedMediaTypes);
    }

    @Override
    protected boolean supports(Class<?> clazz) {
        return true;
    }

    @Override
    public boolean canRead(Type type, @Nullable Class<?> contextClass, @Nullable MediaType mediaType) {
        boolean bl;
        if (type instanceof Class) {
            Class clazz = (Class)type;
            bl = this.canRead(clazz, mediaType);
        } else {
            bl = this.canRead(mediaType);
        }
        return bl;
    }

    @Override
    public boolean canWrite(@Nullable Type type, Class<?> clazz, @Nullable MediaType mediaType) {
        return this.canWrite(clazz, mediaType);
    }

    @Override
    public final void write(final T t2, final @Nullable Type type, @Nullable MediaType contentType, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        final HttpHeaders headers = outputMessage.getHeaders();
        this.addDefaultHeaders(headers, t2, contentType);
        if (outputMessage instanceof StreamingHttpOutputMessage) {
            StreamingHttpOutputMessage streamingOutputMessage = (StreamingHttpOutputMessage)outputMessage;
            streamingOutputMessage.setBody(new StreamingHttpOutputMessage.Body(){

                @Override
                public void writeTo(final OutputStream outputStream) throws IOException {
                    AbstractGenericHttpMessageConverter.this.writeInternal(t2, type, new HttpOutputMessage(){

                        @Override
                        public OutputStream getBody() {
                            return outputStream;
                        }

                        @Override
                        public HttpHeaders getHeaders() {
                            return headers;
                        }
                    });
                }

                @Override
                public boolean repeatable() {
                    return AbstractGenericHttpMessageConverter.this.supportsRepeatableWrites(t2);
                }
            });
        } else {
            this.writeInternal(t2, type, outputMessage);
            outputMessage.getBody().flush();
        }
    }

    @Override
    protected void writeInternal(T t2, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        this.writeInternal(t2, null, outputMessage);
    }

    protected abstract void writeInternal(T var1, @Nullable Type var2, HttpOutputMessage var3) throws IOException, HttpMessageNotWritableException;
}

