/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http.converter;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import keycloakjar.org.springframework.core.io.ByteArrayResource;
import keycloakjar.org.springframework.core.io.InputStreamResource;
import keycloakjar.org.springframework.core.io.Resource;
import keycloakjar.org.springframework.http.HttpInputMessage;
import keycloakjar.org.springframework.http.HttpOutputMessage;
import keycloakjar.org.springframework.http.MediaType;
import keycloakjar.org.springframework.http.MediaTypeFactory;
import keycloakjar.org.springframework.http.converter.AbstractHttpMessageConverter;
import keycloakjar.org.springframework.http.converter.HttpMessageNotReadableException;
import keycloakjar.org.springframework.http.converter.HttpMessageNotWritableException;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.StreamUtils;

public class ResourceHttpMessageConverter
extends AbstractHttpMessageConverter<Resource> {
    private final boolean supportsReadStreaming;

    public ResourceHttpMessageConverter() {
        super(MediaType.ALL);
        this.supportsReadStreaming = true;
    }

    public ResourceHttpMessageConverter(boolean supportsReadStreaming) {
        super(MediaType.ALL);
        this.supportsReadStreaming = supportsReadStreaming;
    }

    @Override
    protected boolean supports(Class<?> clazz) {
        return Resource.class.isAssignableFrom(clazz);
    }

    @Override
    protected Resource readInternal(Class<? extends Resource> clazz, final HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        if (this.supportsReadStreaming && InputStreamResource.class == clazz) {
            return new InputStreamResource(inputMessage.getBody()){

                @Override
                @Nullable
                public String getFilename() {
                    return inputMessage.getHeaders().getContentDisposition().getFilename();
                }

                @Override
                public long contentLength() throws IOException {
                    long length = inputMessage.getHeaders().getContentLength();
                    return length != -1L ? length : super.contentLength();
                }
            };
        }
        if (Resource.class == clazz || ByteArrayResource.class.isAssignableFrom(clazz)) {
            byte[] body2 = StreamUtils.copyToByteArray(inputMessage.getBody());
            return new ByteArrayResource(body2){

                @Override
                @Nullable
                public String getFilename() {
                    return inputMessage.getHeaders().getContentDisposition().getFilename();
                }
            };
        }
        throw new HttpMessageNotReadableException("Unsupported resource class: " + clazz, inputMessage);
    }

    @Override
    protected void writeInternal(Resource resource, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        this.writeContent(resource, outputMessage);
    }

    public void addDefaultHeaders(HttpOutputMessage message, Resource resource, @Nullable MediaType contentType) throws IOException {
        this.addDefaultHeaders(message.getHeaders(), resource, contentType);
    }

    @Override
    protected MediaType getDefaultContentType(Resource resource) {
        return MediaTypeFactory.getMediaType(resource).orElse(MediaType.APPLICATION_OCTET_STREAM);
    }

    @Override
    @Nullable
    protected Long getContentLength(Resource resource, @Nullable MediaType contentType) throws IOException {
        if (InputStreamResource.class == resource.getClass()) {
            return null;
        }
        long contentLength = resource.contentLength();
        return contentLength < 0L ? null : Long.valueOf(contentLength);
    }

    @Override
    protected boolean supportsRepeatableWrites(Resource resource) {
        return !(resource instanceof InputStreamResource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeContent(Resource resource, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        try {
            InputStream in = resource.getInputStream();
            try {
                OutputStream out = outputMessage.getBody();
                in.transferTo(out);
                out.flush();
            }
            catch (NullPointerException nullPointerException) {
            }
            finally {
                try {
                    in.close();
                }
                catch (Throwable throwable) {}
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }
}

