/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http.converter.support;

import keycloakjar.org.springframework.http.converter.FormHttpMessageConverter;
import keycloakjar.org.springframework.http.converter.cbor.KotlinSerializationCborHttpMessageConverter;
import keycloakjar.org.springframework.http.converter.json.GsonHttpMessageConverter;
import keycloakjar.org.springframework.http.converter.json.JsonbHttpMessageConverter;
import keycloakjar.org.springframework.http.converter.json.KotlinSerializationJsonHttpMessageConverter;
import keycloakjar.org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import keycloakjar.org.springframework.http.converter.protobuf.KotlinSerializationProtobufHttpMessageConverter;
import keycloakjar.org.springframework.http.converter.smile.MappingJackson2SmileHttpMessageConverter;
import keycloakjar.org.springframework.http.converter.xml.Jaxb2RootElementHttpMessageConverter;
import keycloakjar.org.springframework.http.converter.xml.MappingJackson2XmlHttpMessageConverter;
import keycloakjar.org.springframework.util.ClassUtils;

public class AllEncompassingFormHttpMessageConverter
extends FormHttpMessageConverter {
    private static final boolean jaxb2Present;
    private static final boolean jackson2Present;
    private static final boolean jackson2XmlPresent;
    private static final boolean jackson2SmilePresent;
    private static final boolean gsonPresent;
    private static final boolean jsonbPresent;
    private static final boolean kotlinSerializationCborPresent;
    private static final boolean kotlinSerializationJsonPresent;
    private static final boolean kotlinSerializationProtobufPresent;

    public AllEncompassingFormHttpMessageConverter() {
        if (jaxb2Present && !jackson2XmlPresent) {
            this.addPartConverter(new Jaxb2RootElementHttpMessageConverter());
        }
        if (kotlinSerializationJsonPresent) {
            this.addPartConverter(new KotlinSerializationJsonHttpMessageConverter());
        }
        if (jackson2Present) {
            this.addPartConverter(new MappingJackson2HttpMessageConverter());
        } else if (gsonPresent) {
            this.addPartConverter(new GsonHttpMessageConverter());
        } else if (jsonbPresent) {
            this.addPartConverter(new JsonbHttpMessageConverter());
        }
        if (jackson2XmlPresent) {
            this.addPartConverter(new MappingJackson2XmlHttpMessageConverter());
        }
        if (jackson2SmilePresent) {
            this.addPartConverter(new MappingJackson2SmileHttpMessageConverter());
        }
        if (kotlinSerializationCborPresent) {
            this.addPartConverter(new KotlinSerializationCborHttpMessageConverter());
        }
        if (kotlinSerializationProtobufPresent) {
            this.addPartConverter(new KotlinSerializationProtobufHttpMessageConverter());
        }
    }

    static {
        ClassLoader classLoader = AllEncompassingFormHttpMessageConverter.class.getClassLoader();
        jaxb2Present = ClassUtils.isPresent("jakarta.xml.bind.Binder", classLoader);
        jackson2Present = ClassUtils.isPresent("com.fasterxml.jackson.databind.ObjectMapper", classLoader) && ClassUtils.isPresent("com.fasterxml.jackson.core.JsonGenerator", classLoader);
        jackson2XmlPresent = ClassUtils.isPresent("com.fasterxml.jackson.dataformat.xml.XmlMapper", classLoader);
        jackson2SmilePresent = ClassUtils.isPresent("com.fasterxml.jackson.dataformat.smile.SmileFactory", classLoader);
        gsonPresent = ClassUtils.isPresent("keycloakjar.com.google.gson.Gson", classLoader);
        jsonbPresent = ClassUtils.isPresent("jakarta.json.bind.Jsonb", classLoader);
        kotlinSerializationCborPresent = ClassUtils.isPresent("kotlinx.serialization.cbor.Cbor", classLoader);
        kotlinSerializationJsonPresent = ClassUtils.isPresent("kotlinx.serialization.json.Json", classLoader);
        kotlinSerializationProtobufPresent = ClassUtils.isPresent("kotlinx.serialization.protobuf.ProtoBuf", classLoader);
    }
}

