/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.web.client;

import java.nio.charset.Charset;
import keycloakjar.org.springframework.http.HttpHeaders;
import keycloakjar.org.springframework.http.HttpStatus;
import keycloakjar.org.springframework.http.HttpStatusCode;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.web.client.HttpStatusCodeException;

public class HttpServerErrorException
extends HttpStatusCodeException {
    private static final long serialVersionUID = -2915754006618138282L;

    public HttpServerErrorException(HttpStatusCode statusCode) {
        super(statusCode);
    }

    public HttpServerErrorException(HttpStatusCode statusCode, String statusText) {
        super(statusCode, statusText);
    }

    public HttpServerErrorException(HttpStatusCode statusCode, String statusText, @Nullable byte[] body2, @Nullable Charset charset) {
        super(statusCode, statusText, body2, charset);
    }

    public HttpServerErrorException(HttpStatusCode statusCode, String statusText, @Nullable HttpHeaders headers, @Nullable byte[] body2, @Nullable Charset charset) {
        super(statusCode, statusText, headers, body2, charset);
    }

    public HttpServerErrorException(String message, HttpStatusCode statusCode, String statusText, @Nullable HttpHeaders headers, @Nullable byte[] body2, @Nullable Charset charset) {
        super(message, statusCode, statusText, headers, body2, charset);
    }

    public static HttpServerErrorException create(HttpStatusCode statusCode, String statusText, HttpHeaders headers, byte[] body2, @Nullable Charset charset) {
        return HttpServerErrorException.create(null, statusCode, statusText, headers, body2, charset);
    }

    public static HttpServerErrorException create(@Nullable String message, HttpStatusCode statusCode, String statusText, HttpHeaders headers, byte[] body2, @Nullable Charset charset) {
        if (statusCode instanceof HttpStatus) {
            HttpStatus status = (HttpStatus)statusCode;
            return switch (status) {
                case HttpStatus.INTERNAL_SERVER_ERROR -> {
                    if (message != null) {
                        yield new InternalServerError(message, statusText, headers, body2, charset);
                    }
                    yield new InternalServerError(statusText, headers, body2, charset);
                }
                case HttpStatus.NOT_IMPLEMENTED -> {
                    if (message != null) {
                        yield new NotImplemented(message, statusText, headers, body2, charset);
                    }
                    yield new NotImplemented(statusText, headers, body2, charset);
                }
                case HttpStatus.BAD_GATEWAY -> {
                    if (message != null) {
                        yield new BadGateway(message, statusText, headers, body2, charset);
                    }
                    yield new BadGateway(statusText, headers, body2, charset);
                }
                case HttpStatus.SERVICE_UNAVAILABLE -> {
                    if (message != null) {
                        yield new ServiceUnavailable(message, statusText, headers, body2, charset);
                    }
                    yield new ServiceUnavailable(statusText, headers, body2, charset);
                }
                case HttpStatus.GATEWAY_TIMEOUT -> {
                    if (message != null) {
                        yield new GatewayTimeout(message, statusText, headers, body2, charset);
                    }
                    yield new GatewayTimeout(statusText, headers, body2, charset);
                }
                default -> message != null ? new HttpServerErrorException(message, statusCode, statusText, headers, body2, charset) : new HttpServerErrorException(statusCode, statusText, headers, body2, charset);
            };
        }
        if (message != null) {
            return new HttpServerErrorException(message, statusCode, statusText, headers, body2, charset);
        }
        return new HttpServerErrorException(statusCode, statusText, headers, body2, charset);
    }

    public static final class InternalServerError
    extends HttpServerErrorException {
        private InternalServerError(String statusText, HttpHeaders headers, byte[] body2, @Nullable Charset charset) {
            super(HttpStatus.INTERNAL_SERVER_ERROR, statusText, headers, body2, charset);
        }

        private InternalServerError(String message, String statusText, HttpHeaders headers, byte[] body2, @Nullable Charset charset) {
            super(message, HttpStatus.INTERNAL_SERVER_ERROR, statusText, headers, body2, charset);
        }
    }

    public static final class NotImplemented
    extends HttpServerErrorException {
        private NotImplemented(String statusText, HttpHeaders headers, byte[] body2, @Nullable Charset charset) {
            super(HttpStatus.NOT_IMPLEMENTED, statusText, headers, body2, charset);
        }

        private NotImplemented(String message, String statusText, HttpHeaders headers, byte[] body2, @Nullable Charset charset) {
            super(message, HttpStatus.NOT_IMPLEMENTED, statusText, headers, body2, charset);
        }
    }

    public static final class BadGateway
    extends HttpServerErrorException {
        private BadGateway(String statusText, HttpHeaders headers, byte[] body2, @Nullable Charset charset) {
            super(HttpStatus.BAD_GATEWAY, statusText, headers, body2, charset);
        }

        private BadGateway(String message, String statusText, HttpHeaders headers, byte[] body2, @Nullable Charset charset) {
            super(message, HttpStatus.BAD_GATEWAY, statusText, headers, body2, charset);
        }
    }

    public static final class ServiceUnavailable
    extends HttpServerErrorException {
        private ServiceUnavailable(String statusText, HttpHeaders headers, byte[] body2, @Nullable Charset charset) {
            super(HttpStatus.SERVICE_UNAVAILABLE, statusText, headers, body2, charset);
        }

        private ServiceUnavailable(String message, String statusText, HttpHeaders headers, byte[] body2, @Nullable Charset charset) {
            super(message, HttpStatus.SERVICE_UNAVAILABLE, statusText, headers, body2, charset);
        }
    }

    public static final class GatewayTimeout
    extends HttpServerErrorException {
        private GatewayTimeout(String statusText, HttpHeaders headers, byte[] body2, @Nullable Charset charset) {
            super(HttpStatus.GATEWAY_TIMEOUT, statusText, headers, body2, charset);
        }

        private GatewayTimeout(String message, String statusText, HttpHeaders headers, byte[] body2, @Nullable Charset charset) {
            super(message, HttpStatus.GATEWAY_TIMEOUT, statusText, headers, body2, charset);
        }
    }
}

