/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.web.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import keycloakjar.org.springframework.http.HttpStatus;
import keycloakjar.org.springframework.http.HttpStatusCode;
import keycloakjar.org.springframework.util.Assert;
import keycloakjar.org.springframework.web.filter.OncePerRequestFilter;
import keycloakjar.org.springframework.web.filter.RelativeRedirectResponseWrapper;

public class RelativeRedirectFilter
extends OncePerRequestFilter {
    private HttpStatusCode redirectStatus = HttpStatus.SEE_OTHER;

    public void setRedirectStatus(HttpStatusCode status) {
        Assert.notNull((Object)status, "Property 'redirectStatus' is required");
        Assert.isTrue(status.is3xxRedirection(), () -> "Not a redirect status code: " + status);
        this.redirectStatus = status;
    }

    public HttpStatusCode getRedirectStatus() {
        return this.redirectStatus;
    }

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        response = RelativeRedirectResponseWrapper.wrapIfNecessary(response, this.redirectStatus);
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

