/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.web.method.annotation;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.Part;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import keycloakjar.org.springframework.beans.BeanUtils;
import keycloakjar.org.springframework.beans.factory.config.ConfigurableBeanFactory;
import keycloakjar.org.springframework.core.MethodParameter;
import keycloakjar.org.springframework.core.convert.ConversionService;
import keycloakjar.org.springframework.core.convert.TypeDescriptor;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;
import keycloakjar.org.springframework.util.StringUtils;
import keycloakjar.org.springframework.web.bind.MissingServletRequestParameterException;
import keycloakjar.org.springframework.web.bind.annotation.RequestParam;
import keycloakjar.org.springframework.web.bind.annotation.RequestPart;
import keycloakjar.org.springframework.web.context.request.NativeWebRequest;
import keycloakjar.org.springframework.web.method.annotation.AbstractNamedValueMethodArgumentResolver;
import keycloakjar.org.springframework.web.method.support.UriComponentsContributor;
import keycloakjar.org.springframework.web.multipart.MultipartException;
import keycloakjar.org.springframework.web.multipart.MultipartFile;
import keycloakjar.org.springframework.web.multipart.MultipartRequest;
import keycloakjar.org.springframework.web.multipart.support.MissingServletRequestPartException;
import keycloakjar.org.springframework.web.multipart.support.MultipartResolutionDelegate;
import keycloakjar.org.springframework.web.util.UriComponentsBuilder;

public class RequestParamMethodArgumentResolver
extends AbstractNamedValueMethodArgumentResolver
implements UriComponentsContributor {
    private static final TypeDescriptor STRING_TYPE_DESCRIPTOR = TypeDescriptor.valueOf(String.class);
    private final boolean useDefaultResolution;

    public RequestParamMethodArgumentResolver(boolean useDefaultResolution) {
        this.useDefaultResolution = useDefaultResolution;
    }

    public RequestParamMethodArgumentResolver(@Nullable ConfigurableBeanFactory beanFactory, boolean useDefaultResolution) {
        super(beanFactory);
        this.useDefaultResolution = useDefaultResolution;
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        if (parameter.hasParameterAnnotation(RequestParam.class)) {
            if (Map.class.isAssignableFrom(parameter.nestedIfOptional().getNestedParameterType())) {
                RequestParam requestParam = parameter.getParameterAnnotation(RequestParam.class);
                return requestParam != null && StringUtils.hasText(requestParam.name());
            }
            return true;
        }
        if (parameter.hasParameterAnnotation(RequestPart.class)) {
            return false;
        }
        if (MultipartResolutionDelegate.isMultipartArgument(parameter = parameter.nestedIfOptional())) {
            return true;
        }
        if (this.useDefaultResolution) {
            return BeanUtils.isSimpleProperty(parameter.getNestedParameterType());
        }
        return false;
    }

    @Override
    protected AbstractNamedValueMethodArgumentResolver.NamedValueInfo createNamedValueInfo(MethodParameter parameter) {
        RequestParam ann = parameter.getParameterAnnotation(RequestParam.class);
        return ann != null ? new RequestParamNamedValueInfo(ann) : new RequestParamNamedValueInfo();
    }

    @Override
    @Nullable
    protected Object resolveName(String name, MethodParameter parameter, NativeWebRequest request) throws Exception {
        String[] files;
        Object mpArg;
        HttpServletRequest servletRequest = request.getNativeRequest(HttpServletRequest.class);
        if (servletRequest != null && (mpArg = MultipartResolutionDelegate.resolveMultipartArgument(name, parameter, servletRequest)) != MultipartResolutionDelegate.UNRESOLVABLE) {
            return mpArg;
        }
        String[] arg = null;
        MultipartRequest multipartRequest = request.getNativeRequest(MultipartRequest.class);
        if (multipartRequest != null && !(files = multipartRequest.getFiles(name)).isEmpty()) {
            String[] stringArray = arg = files.size() == 1 ? files.get(0) : files;
        }
        if (arg == null) {
            String[] paramValues = request.getParameterValues(name);
            if (paramValues == null) {
                paramValues = request.getParameterValues(name + "[]");
            }
            if (paramValues != null) {
                arg = paramValues.length == 1 ? paramValues[0] : paramValues;
            }
        }
        return arg;
    }

    @Override
    protected void handleMissingValue(String name, MethodParameter parameter, NativeWebRequest request) throws Exception {
        this.handleMissingValueInternal(name, parameter, request, false);
    }

    @Override
    protected void handleMissingValueAfterConversion(String name, MethodParameter parameter, NativeWebRequest request) throws Exception {
        this.handleMissingValueInternal(name, parameter, request, true);
    }

    protected void handleMissingValueInternal(String name, MethodParameter parameter, NativeWebRequest request, boolean missingAfterConversion) throws Exception {
        HttpServletRequest servletRequest = request.getNativeRequest(HttpServletRequest.class);
        if (MultipartResolutionDelegate.isMultipartArgument(parameter)) {
            if (servletRequest == null || !MultipartResolutionDelegate.isMultipartRequest(servletRequest)) {
                throw new MultipartException("Current request is not a multipart request");
            }
            throw new MissingServletRequestPartException(name);
        }
        throw new MissingServletRequestParameterException(name, parameter, missingAfterConversion);
    }

    @Override
    public void contributeMethodArgument(MethodParameter parameter, @Nullable Object value, UriComponentsBuilder builder, Map<String, Object> uriVariables, ConversionService conversionService) {
        Class<?> paramType = parameter.getNestedParameterType();
        if (Map.class.isAssignableFrom(paramType) || MultipartFile.class == paramType || Part.class == paramType) {
            return;
        }
        RequestParam requestParam = parameter.getParameterAnnotation(RequestParam.class);
        String name = requestParam != null && StringUtils.hasLength(requestParam.name()) ? requestParam.name() : parameter.getParameterName();
        Assert.state(name != null, "Unresolvable parameter name");
        parameter = parameter.nestedIfOptional();
        if (value instanceof Optional) {
            Optional optional = (Optional)value;
            value = optional.orElse(null);
        }
        if (value == null) {
            if (!(requestParam == null || requestParam.required() && requestParam.defaultValue().equals("\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n"))) {
                return;
            }
            builder.queryParam(name, new Object[0]);
        } else if (value instanceof Collection) {
            Collection elements = (Collection)value;
            for (Object element : elements) {
                element = this.formatUriValue(conversionService, TypeDescriptor.nested(parameter, 1), element);
                builder.queryParam(name, element);
            }
        } else {
            builder.queryParam(name, this.formatUriValue(conversionService, new TypeDescriptor(parameter), value));
        }
    }

    @Nullable
    protected String formatUriValue(@Nullable ConversionService cs, @Nullable TypeDescriptor sourceType, @Nullable Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            String string = (String)value;
            return string;
        }
        if (cs != null) {
            return (String)cs.convert(value, sourceType, STRING_TYPE_DESCRIPTOR);
        }
        return value.toString();
    }

    private static class RequestParamNamedValueInfo
    extends AbstractNamedValueMethodArgumentResolver.NamedValueInfo {
        public RequestParamNamedValueInfo() {
            super("", false, "\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n");
        }

        public RequestParamNamedValueInfo(RequestParam annotation) {
            super(annotation.name(), annotation.required(), annotation.defaultValue());
        }
    }
}

