/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.web.method.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import keycloakjar.org.springframework.core.MethodParameter;
import keycloakjar.org.springframework.core.convert.ConversionService;
import keycloakjar.org.springframework.format.support.DefaultFormattingConversionService;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.web.method.support.HandlerMethodArgumentResolver;
import keycloakjar.org.springframework.web.method.support.UriComponentsContributor;
import keycloakjar.org.springframework.web.util.UriComponentsBuilder;

public class CompositeUriComponentsContributor
implements UriComponentsContributor {
    private final List<Object> contributors;
    private final ConversionService conversionService;

    public CompositeUriComponentsContributor(UriComponentsContributor ... contributors) {
        this.contributors = Arrays.asList((Object[])contributors);
        this.conversionService = new DefaultFormattingConversionService();
    }

    public CompositeUriComponentsContributor(Collection<?> contributors) {
        this(contributors, null);
    }

    public CompositeUriComponentsContributor(@Nullable Collection<?> contributors, @Nullable ConversionService cs) {
        this.contributors = contributors != null ? new ArrayList(contributors) : Collections.emptyList();
        this.conversionService = cs != null ? cs : new DefaultFormattingConversionService();
    }

    public boolean hasContributors() {
        return !this.contributors.isEmpty();
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        for (Object contributor : this.contributors) {
            HandlerMethodArgumentResolver resolver;
            if (contributor instanceof UriComponentsContributor) {
                UriComponentsContributor ucc = (UriComponentsContributor)contributor;
                if (!ucc.supportsParameter(parameter)) continue;
                return true;
            }
            if (!(contributor instanceof HandlerMethodArgumentResolver) || !(resolver = (HandlerMethodArgumentResolver)contributor).supportsParameter(parameter)) continue;
            return false;
        }
        return false;
    }

    @Override
    public void contributeMethodArgument(MethodParameter parameter, Object value, UriComponentsBuilder builder, Map<String, Object> uriVariables, ConversionService conversionService) {
        for (Object contributor : this.contributors) {
            HandlerMethodArgumentResolver resolver;
            if (contributor instanceof UriComponentsContributor) {
                UriComponentsContributor ucc = (UriComponentsContributor)contributor;
                if (!ucc.supportsParameter(parameter)) continue;
                ucc.contributeMethodArgument(parameter, value, builder, uriVariables, conversionService);
                break;
            }
            if (!(contributor instanceof HandlerMethodArgumentResolver) || !(resolver = (HandlerMethodArgumentResolver)contributor).supportsParameter(parameter)) continue;
            break;
        }
    }

    public void contributeMethodArgument(MethodParameter parameter, Object value, UriComponentsBuilder builder, Map<String, Object> uriVariables) {
        this.contributeMethodArgument(parameter, value, builder, uriVariables, this.conversionService);
    }
}

