/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.web.multipart.support;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import keycloakjar.org.springframework.web.context.WebApplicationContext;
import keycloakjar.org.springframework.web.context.support.WebApplicationContextUtils;
import keycloakjar.org.springframework.web.filter.OncePerRequestFilter;
import keycloakjar.org.springframework.web.multipart.MultipartHttpServletRequest;
import keycloakjar.org.springframework.web.multipart.MultipartResolver;
import keycloakjar.org.springframework.web.multipart.support.StandardServletMultipartResolver;

public class MultipartFilter
extends OncePerRequestFilter {
    public static final String DEFAULT_MULTIPART_RESOLVER_BEAN_NAME = "filterMultipartResolver";
    private final MultipartResolver defaultMultipartResolver = new StandardServletMultipartResolver();
    private String multipartResolverBeanName = "filterMultipartResolver";

    public void setMultipartResolverBeanName(String multipartResolverBeanName) {
        this.multipartResolverBeanName = multipartResolverBeanName;
    }

    protected String getMultipartResolverBeanName() {
        return this.multipartResolverBeanName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        HttpServletRequest processedRequest;
        MultipartResolver multipartResolver = this.lookupMultipartResolver(request);
        if (multipartResolver.isMultipart(processedRequest = request)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Resolving multipart request");
            }
            processedRequest = multipartResolver.resolveMultipart(processedRequest);
        } else if (this.logger.isTraceEnabled()) {
            this.logger.trace("Not a multipart request");
        }
        try {
            filterChain.doFilter((ServletRequest)processedRequest, (ServletResponse)response);
        }
        finally {
            if (processedRequest instanceof MultipartHttpServletRequest) {
                MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)processedRequest;
                multipartResolver.cleanupMultipart(multipartRequest);
            }
        }
    }

    protected MultipartResolver lookupMultipartResolver(HttpServletRequest request) {
        return this.lookupMultipartResolver();
    }

    protected MultipartResolver lookupMultipartResolver() {
        WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext(this.getServletContext());
        String beanName = this.getMultipartResolverBeanName();
        if (wac != null && wac.containsBean(beanName)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Using MultipartResolver '" + beanName + "' for MultipartFilter");
            }
            return (MultipartResolver)wac.getBean(beanName, MultipartResolver.class);
        }
        return this.defaultMultipartResolver;
    }
}

