/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.keycloak;

import java.util.Arrays;
import java.util.Objects;
import org.camunda.bpm.extension.keycloak.KeycloakUserQuery;

public class CacheableKeycloakUserQuery {
    private final String id;
    private final String[] ids;
    private final String firstName;
    private final String firstNameLike;
    private final String lastName;
    private final String lastNameLike;
    private final String email;
    private final String emailLike;
    private final String groupId;

    private CacheableKeycloakUserQuery(KeycloakUserQuery delegate) {
        this.id = delegate.getId();
        this.ids = delegate.getIds();
        this.firstName = delegate.getFirstName();
        this.firstNameLike = delegate.getFirstNameLike();
        this.lastName = delegate.getLastName();
        this.lastNameLike = delegate.getLastNameLike();
        this.email = delegate.getEmail();
        this.emailLike = delegate.getEmailLike();
        this.groupId = delegate.getGroupId();
    }

    public static CacheableKeycloakUserQuery of(KeycloakUserQuery userQuery) {
        return new CacheableKeycloakUserQuery(userQuery);
    }

    public String getId() {
        return this.id;
    }

    public String[] getIds() {
        return this.ids;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getFirstNameLike() {
        return this.firstNameLike;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getLastNameLike() {
        return this.lastNameLike;
    }

    public String getEmail() {
        return this.email;
    }

    public String getEmailLike() {
        return this.emailLike;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheableKeycloakUserQuery that = (CacheableKeycloakUserQuery)o;
        return Objects.equals(this.id, that.id) && Arrays.equals(this.ids, that.ids) && Objects.equals(this.firstName, that.firstName) && Objects.equals(this.firstNameLike, that.firstNameLike) && Objects.equals(this.lastName, that.lastName) && Objects.equals(this.lastNameLike, that.lastNameLike) && Objects.equals(this.email, that.email) && Objects.equals(this.emailLike, that.emailLike) && Objects.equals(this.groupId, that.groupId);
    }

    public int hashCode() {
        int result = Objects.hash(this.id, this.firstName, this.firstNameLike, this.lastName, this.lastNameLike, this.email, this.emailLike, this.groupId);
        result = 31 * result + Arrays.hashCode(this.ids);
        return result;
    }
}

