/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.keycloak.rest;

import keycloakjar.org.springframework.http.HttpEntity;
import keycloakjar.org.springframework.http.HttpMethod;
import keycloakjar.org.springframework.http.ResponseEntity;
import keycloakjar.org.springframework.web.client.HttpClientErrorException;
import keycloakjar.org.springframework.web.client.RestClientException;
import keycloakjar.org.springframework.web.client.RestTemplate;
import org.camunda.bpm.extension.keycloak.KeycloakContextProvider;
import org.camunda.bpm.extension.keycloak.util.KeycloakPluginLogger;

public class KeycloakRestTemplate
extends RestTemplate {
    private KeycloakContextProvider keycloakContextProvider;

    public <T> ResponseEntity<T> exchange(String url, HttpMethod method, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        return this.exchange(url, method, this.keycloakContextProvider.createApiRequestEntity(), responseType, uriVariables);
    }

    @Override
    public <T> ResponseEntity<T> exchange(String url, HttpMethod method, HttpEntity<?> requestEntity, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        try {
            return super.exchange(url, method, requestEntity, responseType, uriVariables);
        }
        catch (HttpClientErrorException.Unauthorized u) {
            KeycloakPluginLogger.INSTANCE.requestFailedUnauthorized(url);
            this.keycloakContextProvider.invalidateToken();
            return super.exchange(url, method, this.keycloakContextProvider.createApiRequestEntity(), responseType, uriVariables);
        }
    }

    public void registerKeycloakContextProvider(KeycloakContextProvider keycloakContextProvider) {
        this.keycloakContextProvider = keycloakContextProvider;
    }
}

