/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.keycloak;

import java.nio.charset.StandardCharsets;

public class KeycloakConfiguration {
    protected String keycloakIssuerUrl;
    protected String keycloakAdminUrl;
    protected String clientId;
    protected String clientSecret;
    protected boolean useEmailAsCamundaUserId = false;
    protected boolean useUsernameAsCamundaUserId = false;
    protected boolean useGroupPathAsCamundaGroupId = false;
    protected String administratorGroupName;
    protected String administratorUserId;
    protected boolean authorizationCheckEnabled = true;
    protected boolean disableSSLCertificateValidation = false;
    protected int maxHttpConnections = 50;
    protected String charset = StandardCharsets.UTF_8.name();
    protected Integer maxResultSize = 250;
    protected String proxyUri = null;
    protected String proxyUser = null;
    protected String proxyPassword = null;
    private boolean cacheEnabled;
    private int maxCacheSize = 500;
    private int cacheExpirationTimeoutMin = 15;
    private boolean loginCacheEnabled = false;
    private int loginCacheSize = 50;
    private int loginCacheExpirationTimeoutMin = 15;

    public String getKeycloakIssuerUrl() {
        return this.keycloakIssuerUrl;
    }

    public void setKeycloakIssuerUrl(String keycloakIssuerUrl) {
        this.keycloakIssuerUrl = this.unifyUrl(keycloakIssuerUrl);
    }

    public String getKeycloakAdminUrl() {
        return this.keycloakAdminUrl;
    }

    public void setKeycloakAdminUrl(String keycloakAdminUrl) {
        this.keycloakAdminUrl = this.unifyUrl(keycloakAdminUrl);
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public boolean isUseEmailAsCamundaUserId() {
        return this.useEmailAsCamundaUserId;
    }

    public void setUseEmailAsCamundaUserId(boolean useEmailAsCamundaUserId) {
        this.useEmailAsCamundaUserId = useEmailAsCamundaUserId;
    }

    public boolean isUseUsernameAsCamundaUserId() {
        return this.useUsernameAsCamundaUserId;
    }

    public void setUseUsernameAsCamundaUserId(boolean useUsernameAsCamundaUserId) {
        this.useUsernameAsCamundaUserId = useUsernameAsCamundaUserId;
    }

    public boolean isUseGroupPathAsCamundaGroupId() {
        return this.useGroupPathAsCamundaGroupId;
    }

    public void setUseGroupPathAsCamundaGroupId(boolean useGroupPathAsCamundaGroupId) {
        this.useGroupPathAsCamundaGroupId = useGroupPathAsCamundaGroupId;
    }

    public String getAdministratorGroupName() {
        return this.administratorGroupName;
    }

    public void setAdministratorGroupName(String administratorGroupName) {
        this.administratorGroupName = administratorGroupName;
    }

    public String getAdministratorUserId() {
        return this.administratorUserId;
    }

    public void setAdministratorUserId(String administratorUserId) {
        this.administratorUserId = administratorUserId;
    }

    public boolean isAuthorizationCheckEnabled() {
        return this.authorizationCheckEnabled;
    }

    public void setAuthorizationCheckEnabled(boolean authorizationCheckEnabled) {
        this.authorizationCheckEnabled = authorizationCheckEnabled;
    }

    public boolean isDisableSSLCertificateValidation() {
        return this.disableSSLCertificateValidation;
    }

    public void setDisableSSLCertificateValidation(boolean disableSSLCertificateValidation) {
        this.disableSSLCertificateValidation = disableSSLCertificateValidation;
    }

    public int getMaxHttpConnections() {
        return this.maxHttpConnections;
    }

    public void setMaxHttpConnections(int maxHttpConnections) {
        this.maxHttpConnections = maxHttpConnections;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public Integer getMaxResultSize() {
        return this.maxResultSize;
    }

    public void setMaxResultSize(Integer maxResultSize) {
        this.maxResultSize = maxResultSize;
    }

    public String getProxyUri() {
        return this.proxyUri;
    }

    public void setProxyUri(String proxyUri) {
        this.proxyUri = proxyUri;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public int getCacheExpirationTimeoutMin() {
        return this.cacheExpirationTimeoutMin;
    }

    public void setCacheEnabled(boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
    }

    public void setMaxCacheSize(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
    }

    public void setCacheExpirationTimeoutMin(int cacheExpirationTimeoutMin) {
        this.cacheExpirationTimeoutMin = cacheExpirationTimeoutMin;
    }

    public boolean isLoginCacheEnabled() {
        return this.loginCacheEnabled;
    }

    public void setLoginCacheEnabled(boolean loginCacheEnabled) {
        this.loginCacheEnabled = loginCacheEnabled;
    }

    public int getLoginCacheSize() {
        return this.loginCacheSize;
    }

    public void setLoginCacheSize(int loginCacheSize) {
        this.loginCacheSize = loginCacheSize;
    }

    public int getLoginCacheExpirationTimeoutMin() {
        return this.loginCacheExpirationTimeoutMin;
    }

    public void setLoginCacheExpirationTimeoutMin(int loginCacheExpirationTimeoutMin) {
        this.loginCacheExpirationTimeoutMin = loginCacheExpirationTimeoutMin;
    }

    private String unifyUrl(String url) {
        if (url.endsWith("/")) {
            return url.substring(0, url.length() - 1);
        }
        return url;
    }
}

