/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.keycloak.cache;

import java.time.Duration;
import org.camunda.bpm.extension.keycloak.KeycloakConfiguration;

public class CacheConfiguration {
    private final boolean enabled;
    private final int maxSize;
    private final Duration expirationTimeout;

    private CacheConfiguration(boolean enabled, int maxSize, Duration expirationTimeout) {
        this.enabled = enabled;
        this.maxSize = maxSize;
        this.expirationTimeout = expirationTimeout;
    }

    public static CacheConfiguration from(KeycloakConfiguration keycloakConfiguration) {
        return new CacheConfiguration(keycloakConfiguration.isCacheEnabled(), keycloakConfiguration.getMaxCacheSize(), Duration.ofMinutes(keycloakConfiguration.getCacheExpirationTimeoutMin()));
    }

    public static CacheConfiguration fromLoginConfigOf(KeycloakConfiguration keycloakConfiguration) {
        return new CacheConfiguration(keycloakConfiguration.isLoginCacheEnabled(), keycloakConfiguration.getLoginCacheSize(), Duration.ofMinutes(keycloakConfiguration.getLoginCacheExpirationTimeoutMin()));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public Duration getExpirationTimeout() {
        return this.expirationTimeout;
    }
}

