/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.keycloak.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import org.camunda.bpm.extension.keycloak.json.JsonException;

public class JsonUtil {
    public static JsonObject parseAsJsonObject(String jsonString) throws JsonException {
        try {
            return JsonParser.parseString((String)jsonString).getAsJsonObject();
        }
        catch (JsonParseException | IllegalStateException ex) {
            throw new JsonException("Unable to parse as JsonObject: " + jsonString, ex);
        }
    }

    public static JsonArray parseAsJsonArray(String jsonString) throws JsonException {
        try {
            return JsonParser.parseString((String)jsonString).getAsJsonArray();
        }
        catch (JsonParseException | IllegalStateException ex) {
            throw new JsonException("Unable to parse as JsonArray: " + jsonString, ex);
        }
    }

    public static String parseAsJsonObjectAndGetMemberAsString(String jsonString, String memberName) throws JsonException {
        return JsonUtil.getJsonString(JsonUtil.parseAsJsonObject(jsonString), memberName);
    }

    public static String getJsonString(JsonObject jsonObject, String memberName) throws JsonException {
        try {
            JsonElement element = jsonObject.get(memberName);
            return element == null ? null : element.getAsString();
        }
        catch (ClassCastException | IllegalStateException ex) {
            throw new JsonException("Unable to get '" + memberName + "' from JsonObject " + jsonObject.toString(), ex);
        }
    }

    public static String getOptJsonString(JsonObject jsonObject, String memberName) throws JsonException {
        try {
            JsonElement element = jsonObject.get(memberName);
            return element == null ? "" : element.getAsString();
        }
        catch (ClassCastException | IllegalStateException ex) {
            throw new JsonException("Unable to get '" + memberName + "' from JsonObject " + jsonObject.toString(), ex);
        }
    }

    public static Long getJsonLong(JsonObject jsonObject, String memberName) throws JsonException {
        try {
            JsonElement element = jsonObject.get(memberName);
            return element == null ? null : Long.valueOf(element.getAsLong());
        }
        catch (ClassCastException | IllegalStateException ex) {
            throw new JsonException("Unable to get '" + memberName + "' from JsonObject " + jsonObject.toString(), ex);
        }
    }

    public static JsonObject getJsonObject(JsonObject jsonObject, String memberName) throws JsonException {
        if (jsonObject == null) {
            return null;
        }
        try {
            JsonElement element = jsonObject.get(memberName);
            return element == null ? null : element.getAsJsonObject();
        }
        catch (ClassCastException | IllegalStateException ex) {
            throw new JsonException("Unable to get '" + memberName + "' from JsonObject " + jsonObject.toString(), ex);
        }
    }

    public static JsonArray getJsonArray(JsonObject jsonObject, String memberName) throws JsonException {
        if (jsonObject == null) {
            return new JsonArray();
        }
        try {
            JsonElement element = jsonObject.get(memberName);
            return element == null ? new JsonArray() : element.getAsJsonArray();
        }
        catch (ClassCastException | IllegalStateException ex) {
            throw new JsonException("Unable to get '" + memberName + "' from JsonObject " + jsonObject.toString(), ex);
        }
    }

    public static JsonObject getJsonObjectAtIndex(JsonArray jsonArray, int i) throws JsonException {
        try {
            return jsonArray.get(i).getAsJsonObject();
        }
        catch (IllegalStateException | IndexOutOfBoundsException ex) {
            throw new JsonException("Unable to get index " + i + " from JsonArray " + jsonArray.toString(), ex);
        }
    }

    public static String getJsonStringAtIndex(JsonArray jsonArray, int i) throws JsonException {
        try {
            return jsonArray.get(i).getAsString();
        }
        catch (ClassCastException | IllegalStateException | IndexOutOfBoundsException ex) {
            throw new JsonException("Unable to get index " + i + " from JsonArray " + jsonArray.toString(), ex);
        }
    }

    public static JsonObject findFirst(JsonArray list, String attributeToMatch, String attributeValue) throws JsonException {
        for (int i = 0; i < list.size(); ++i) {
            JsonObject result = list.get(i).getAsJsonObject();
            if (!attributeValue.equalsIgnoreCase(JsonUtil.getJsonString(result, attributeToMatch))) continue;
            return result;
        }
        return null;
    }
}

