/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.keycloak.util;

import org.camunda.commons.logging.BaseLogger;

public class KeycloakPluginLogger
extends BaseLogger {
    public static final String PROJECT_CODE = "KEYCLOAK";
    public static final KeycloakPluginLogger INSTANCE = (KeycloakPluginLogger)BaseLogger.createLogger(KeycloakPluginLogger.class, (String)"KEYCLOAK", (String)"org.camunda.bpm.extension.keycloak", (String)"01");

    public void pluginActivated(String pluginClassName, String engineName) {
        this.logInfo("001", "PLUGIN {} activated on process engine {}", new Object[]{pluginClassName, engineName});
    }

    public void grantGroupPermissions(String administratorGroupName, String administratorGroupId, String resourceName) {
        this.logInfo("002", "GRANT group {}[{}] ALL permissions on resource {}.", new Object[]{administratorGroupName, administratorGroupId, resourceName});
    }

    public void grantUserPermissions(String administratorUserName, String resourceName) {
        this.logInfo("003", "GRANT user {} ALL permissions on resource {}.", new Object[]{administratorUserName, resourceName});
    }

    public void missingConfigurationParameter(String parameter) {
        this.logError("004", "CONFIG parameter {} is mandatory, but hasn't been found", new Object[]{parameter});
    }

    public void activationError(String pluginClassName, String engineName, String errorMessage) {
        this.logError("005", "PLUGIN {} could not be activated on process engine {}: {}", new Object[]{pluginClassName, engineName, errorMessage});
    }

    public void requestTokenFailed(Exception exception) {
        this.logError("011", "TOKEN request failed: {}", new Object[]{exception.getMessage()});
    }

    public void refreshTokenFailed(Exception exception) {
        this.logError("012", "TOKEN refresh failed: {}", new Object[]{exception.getMessage()});
    }

    public void requestFailedUnauthorized(String request) {
        this.logWarn("013", "REQUEST {} failed unauthorized - auto retry once with new token. Please check access token lifespan, session timeouts, etc.", new Object[]{request});
    }

    public void missingRefreshToken() {
        this.logWarn("014", "TOKEN refresh not possible - please activate the 'Use Refresh Tokens For Client Credentials Grant' option.", new Object[0]);
    }

    public void userNotFound(String userId, Exception exception) {
        this.logWarn("020", "FIND userId {} failed: {}", new Object[]{userId, exception.getMessage()});
    }

    public void userQueryFilter(String filter) {
        this.logDebug("021", "FIND user with query {}", new Object[]{filter});
    }

    public void groupQueryFilter(String filter) {
        this.logDebug("022", "FIND group with query {}", new Object[]{filter});
    }

    public void groupQueryResult(String summary) {
        this.logDebug("050", summary, new Object[0]);
    }

    public void userQueryResult(String summary) {
        this.logDebug("051", summary, new Object[0]);
    }
}

