/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.impl.juel;

import java.lang.reflect.Method;
import java.util.Collection;
import org.camunda.bpm.impl.juel.Bindings;
import org.camunda.bpm.impl.juel.ExpressionNode;
import org.camunda.bpm.impl.juel.FunctionNode;
import org.camunda.bpm.impl.juel.IdentifierNode;
import org.camunda.bpm.impl.juel.LocalMessages;
import org.camunda.bpm.impl.juel.TypeConverter;
import org.camunda.bpm.impl.juel.jakarta.el.ELException;
import org.camunda.bpm.impl.juel.jakarta.el.FunctionMapper;
import org.camunda.bpm.impl.juel.jakarta.el.ValueExpression;
import org.camunda.bpm.impl.juel.jakarta.el.VariableMapper;

public class Tree {
    private final ExpressionNode root;
    private final Collection<FunctionNode> functions;
    private final Collection<IdentifierNode> identifiers;
    private final boolean deferred;

    public Tree(ExpressionNode root, Collection<FunctionNode> functions, Collection<IdentifierNode> identifiers, boolean deferred) {
        this.root = root;
        this.functions = functions;
        this.identifiers = identifiers;
        this.deferred = deferred;
    }

    public Iterable<FunctionNode> getFunctionNodes() {
        return this.functions;
    }

    public Iterable<IdentifierNode> getIdentifierNodes() {
        return this.identifiers;
    }

    public ExpressionNode getRoot() {
        return this.root;
    }

    public boolean isDeferred() {
        return this.deferred;
    }

    public String toString() {
        return this.getRoot().getStructuralId(null);
    }

    public Bindings bind(FunctionMapper fnMapper, VariableMapper varMapper) {
        return this.bind(fnMapper, varMapper, null);
    }

    public Bindings bind(FunctionMapper fnMapper, VariableMapper varMapper, TypeConverter converter) {
        Method[] methods = null;
        if (!this.functions.isEmpty()) {
            if (fnMapper == null) {
                throw new ELException(LocalMessages.get("error.function.nomapper", new Object[0]));
            }
            methods = new Method[this.functions.size()];
            for (FunctionNode node : this.functions) {
                String image = node.getName();
                Method method = null;
                int colon = image.indexOf(58);
                method = colon < 0 ? fnMapper.resolveFunction("", image) : fnMapper.resolveFunction(image.substring(0, colon), image.substring(colon + 1));
                if (method == null) {
                    throw new ELException(LocalMessages.get("error.function.notfound", image));
                }
                if (node.isVarArgs() && method.isVarArgs() ? method.getParameterTypes().length > node.getParamCount() + 1 : method.getParameterTypes().length != node.getParamCount()) {
                    throw new ELException(LocalMessages.get("error.function.params", image));
                }
                methods[node.getIndex()] = method;
            }
        }
        ValueExpression[] expressions = null;
        if (this.identifiers.size() > 0) {
            expressions = new ValueExpression[this.identifiers.size()];
            for (IdentifierNode node : this.identifiers) {
                ValueExpression expression = null;
                if (varMapper != null) {
                    expression = varMapper.resolveVariable(node.getName());
                }
                expressions[node.getIndex()] = expression;
            }
        }
        return new Bindings(methods, expressions, converter);
    }
}

