/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.17.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.camunda.community.rest.client.dto.HistoricActivityInstanceQueryDtoSorting;

/**
 * A historic activity instance query which defines a group of historic activity instances
 */
@ApiModel(description = "A historic activity instance query which defines a group of historic activity instances")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-05-23T14:22:53.022768Z[Etc/UTC]")
public class HistoricActivityInstanceQueryDto {
  public static final String SERIALIZED_NAME_ACTIVITY_INSTANCE_ID = "activityInstanceId";
  @SerializedName(SERIALIZED_NAME_ACTIVITY_INSTANCE_ID)
  private String activityInstanceId;

  public static final String SERIALIZED_NAME_PROCESS_INSTANCE_ID = "processInstanceId";
  @SerializedName(SERIALIZED_NAME_PROCESS_INSTANCE_ID)
  private String processInstanceId;

  public static final String SERIALIZED_NAME_PROCESS_DEFINITION_ID = "processDefinitionId";
  @SerializedName(SERIALIZED_NAME_PROCESS_DEFINITION_ID)
  private String processDefinitionId;

  public static final String SERIALIZED_NAME_EXECUTION_ID = "executionId";
  @SerializedName(SERIALIZED_NAME_EXECUTION_ID)
  private String executionId;

  public static final String SERIALIZED_NAME_ACTIVITY_ID = "activityId";
  @SerializedName(SERIALIZED_NAME_ACTIVITY_ID)
  private String activityId;

  public static final String SERIALIZED_NAME_ACTIVITY_NAME = "activityName";
  @SerializedName(SERIALIZED_NAME_ACTIVITY_NAME)
  private String activityName;

  public static final String SERIALIZED_NAME_ACTIVITY_TYPE = "activityType";
  @SerializedName(SERIALIZED_NAME_ACTIVITY_TYPE)
  private String activityType;

  public static final String SERIALIZED_NAME_TASK_ASSIGNEE = "taskAssignee";
  @SerializedName(SERIALIZED_NAME_TASK_ASSIGNEE)
  private String taskAssignee;

  public static final String SERIALIZED_NAME_FINISHED = "finished";
  @SerializedName(SERIALIZED_NAME_FINISHED)
  private Boolean finished;

  public static final String SERIALIZED_NAME_UNFINISHED = "unfinished";
  @SerializedName(SERIALIZED_NAME_UNFINISHED)
  private Boolean unfinished;

  public static final String SERIALIZED_NAME_CANCELED = "canceled";
  @SerializedName(SERIALIZED_NAME_CANCELED)
  private Boolean canceled;

  public static final String SERIALIZED_NAME_COMPLETE_SCOPE = "completeScope";
  @SerializedName(SERIALIZED_NAME_COMPLETE_SCOPE)
  private Boolean completeScope;

  public static final String SERIALIZED_NAME_STARTED_BEFORE = "startedBefore";
  @SerializedName(SERIALIZED_NAME_STARTED_BEFORE)
  private Date startedBefore;

  public static final String SERIALIZED_NAME_STARTED_AFTER = "startedAfter";
  @SerializedName(SERIALIZED_NAME_STARTED_AFTER)
  private Date startedAfter;

  public static final String SERIALIZED_NAME_FINISHED_BEFORE = "finishedBefore";
  @SerializedName(SERIALIZED_NAME_FINISHED_BEFORE)
  private Date finishedBefore;

  public static final String SERIALIZED_NAME_FINISHED_AFTER = "finishedAfter";
  @SerializedName(SERIALIZED_NAME_FINISHED_AFTER)
  private Date finishedAfter;

  public static final String SERIALIZED_NAME_TENANT_ID_IN = "tenantIdIn";
  @SerializedName(SERIALIZED_NAME_TENANT_ID_IN)
  private List<String> tenantIdIn = null;

  public static final String SERIALIZED_NAME_WITHOUT_TENANT_ID = "withoutTenantId";
  @SerializedName(SERIALIZED_NAME_WITHOUT_TENANT_ID)
  private Boolean withoutTenantId;

  public static final String SERIALIZED_NAME_SORTING = "sorting";
  @SerializedName(SERIALIZED_NAME_SORTING)
  private List<HistoricActivityInstanceQueryDtoSorting> sorting = null;


  public HistoricActivityInstanceQueryDto activityInstanceId(String activityInstanceId) {
    
    this.activityInstanceId = activityInstanceId;
    return this;
  }

   /**
   * Filter by activity instance id.
   * @return activityInstanceId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by activity instance id.")

  public String getActivityInstanceId() {
    return activityInstanceId;
  }


  public void setActivityInstanceId(String activityInstanceId) {
    this.activityInstanceId = activityInstanceId;
  }


  public HistoricActivityInstanceQueryDto processInstanceId(String processInstanceId) {
    
    this.processInstanceId = processInstanceId;
    return this;
  }

   /**
   * Filter by process instance id.
   * @return processInstanceId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by process instance id.")

  public String getProcessInstanceId() {
    return processInstanceId;
  }


  public void setProcessInstanceId(String processInstanceId) {
    this.processInstanceId = processInstanceId;
  }


  public HistoricActivityInstanceQueryDto processDefinitionId(String processDefinitionId) {
    
    this.processDefinitionId = processDefinitionId;
    return this;
  }

   /**
   * Filter by process definition id.
   * @return processDefinitionId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by process definition id.")

  public String getProcessDefinitionId() {
    return processDefinitionId;
  }


  public void setProcessDefinitionId(String processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }


  public HistoricActivityInstanceQueryDto executionId(String executionId) {
    
    this.executionId = executionId;
    return this;
  }

   /**
   * Filter by the id of the execution that executed the activity instance.
   * @return executionId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by the id of the execution that executed the activity instance.")

  public String getExecutionId() {
    return executionId;
  }


  public void setExecutionId(String executionId) {
    this.executionId = executionId;
  }


  public HistoricActivityInstanceQueryDto activityId(String activityId) {
    
    this.activityId = activityId;
    return this;
  }

   /**
   * Filter by the activity id (according to BPMN 2.0 XML).
   * @return activityId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by the activity id (according to BPMN 2.0 XML).")

  public String getActivityId() {
    return activityId;
  }


  public void setActivityId(String activityId) {
    this.activityId = activityId;
  }


  public HistoricActivityInstanceQueryDto activityName(String activityName) {
    
    this.activityName = activityName;
    return this;
  }

   /**
   * Filter by the activity name (according to BPMN 2.0 XML).
   * @return activityName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by the activity name (according to BPMN 2.0 XML).")

  public String getActivityName() {
    return activityName;
  }


  public void setActivityName(String activityName) {
    this.activityName = activityName;
  }


  public HistoricActivityInstanceQueryDto activityType(String activityType) {
    
    this.activityType = activityType;
    return this;
  }

   /**
   * Filter by activity type.
   * @return activityType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by activity type.")

  public String getActivityType() {
    return activityType;
  }


  public void setActivityType(String activityType) {
    this.activityType = activityType;
  }


  public HistoricActivityInstanceQueryDto taskAssignee(String taskAssignee) {
    
    this.taskAssignee = taskAssignee;
    return this;
  }

   /**
   * Only include activity instances that are user tasks and assigned to a given user.
   * @return taskAssignee
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Only include activity instances that are user tasks and assigned to a given user.")

  public String getTaskAssignee() {
    return taskAssignee;
  }


  public void setTaskAssignee(String taskAssignee) {
    this.taskAssignee = taskAssignee;
  }


  public HistoricActivityInstanceQueryDto finished(Boolean finished) {
    
    this.finished = finished;
    return this;
  }

   /**
   * Only include finished activity instances. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; behaves the same as when the property is not set.
   * @return finished
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Only include finished activity instances. Value may only be `true`, as `false` behaves the same as when the property is not set.")

  public Boolean getFinished() {
    return finished;
  }


  public void setFinished(Boolean finished) {
    this.finished = finished;
  }


  public HistoricActivityInstanceQueryDto unfinished(Boolean unfinished) {
    
    this.unfinished = unfinished;
    return this;
  }

   /**
   * Only include unfinished activity instances. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; behaves the same as when the property is not set.
   * @return unfinished
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Only include unfinished activity instances. Value may only be `true`, as `false` behaves the same as when the property is not set.")

  public Boolean getUnfinished() {
    return unfinished;
  }


  public void setUnfinished(Boolean unfinished) {
    this.unfinished = unfinished;
  }


  public HistoricActivityInstanceQueryDto canceled(Boolean canceled) {
    
    this.canceled = canceled;
    return this;
  }

   /**
   * Only include canceled activity instances. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; behaves the same as when the property is not set.
   * @return canceled
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Only include canceled activity instances. Value may only be `true`, as `false` behaves the same as when the property is not set.")

  public Boolean getCanceled() {
    return canceled;
  }


  public void setCanceled(Boolean canceled) {
    this.canceled = canceled;
  }


  public HistoricActivityInstanceQueryDto completeScope(Boolean completeScope) {
    
    this.completeScope = completeScope;
    return this;
  }

   /**
   * Only include activity instances which completed a scope. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; behaves the same as when the property is not set.
   * @return completeScope
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Only include activity instances which completed a scope. Value may only be `true`, as `false` behaves the same as when the property is not set.")

  public Boolean getCompleteScope() {
    return completeScope;
  }


  public void setCompleteScope(Boolean completeScope) {
    this.completeScope = completeScope;
  }


  public HistoricActivityInstanceQueryDto startedBefore(Date startedBefore) {
    
    this.startedBefore = startedBefore;
    return this;
  }

   /**
   * Restrict to instances that were started before the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return startedBefore
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to instances that were started before the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")

  public Date getStartedBefore() {
    return startedBefore;
  }


  public void setStartedBefore(Date startedBefore) {
    this.startedBefore = startedBefore;
  }


  public HistoricActivityInstanceQueryDto startedAfter(Date startedAfter) {
    
    this.startedAfter = startedAfter;
    return this;
  }

   /**
   * Restrict to instances that were started after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return startedAfter
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to instances that were started after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")

  public Date getStartedAfter() {
    return startedAfter;
  }


  public void setStartedAfter(Date startedAfter) {
    this.startedAfter = startedAfter;
  }


  public HistoricActivityInstanceQueryDto finishedBefore(Date finishedBefore) {
    
    this.finishedBefore = finishedBefore;
    return this;
  }

   /**
   * Restrict to instances that were finished before the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return finishedBefore
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to instances that were finished before the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")

  public Date getFinishedBefore() {
    return finishedBefore;
  }


  public void setFinishedBefore(Date finishedBefore) {
    this.finishedBefore = finishedBefore;
  }


  public HistoricActivityInstanceQueryDto finishedAfter(Date finishedAfter) {
    
    this.finishedAfter = finishedAfter;
    return this;
  }

   /**
   * Restrict to instances that were finished after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return finishedAfter
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to instances that were finished after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")

  public Date getFinishedAfter() {
    return finishedAfter;
  }


  public void setFinishedAfter(Date finishedAfter) {
    this.finishedAfter = finishedAfter;
  }


  public HistoricActivityInstanceQueryDto tenantIdIn(List<String> tenantIdIn) {
    
    this.tenantIdIn = tenantIdIn;
    return this;
  }

  public HistoricActivityInstanceQueryDto addTenantIdInItem(String tenantIdInItem) {
    if (this.tenantIdIn == null) {
      this.tenantIdIn = new ArrayList<String>();
    }
    this.tenantIdIn.add(tenantIdInItem);
    return this;
  }

   /**
   * Must be a JSON array of Strings. An activity instance must have one of the given tenant ids.
   * @return tenantIdIn
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Must be a JSON array of Strings. An activity instance must have one of the given tenant ids.")

  public List<String> getTenantIdIn() {
    return tenantIdIn;
  }


  public void setTenantIdIn(List<String> tenantIdIn) {
    this.tenantIdIn = tenantIdIn;
  }


  public HistoricActivityInstanceQueryDto withoutTenantId(Boolean withoutTenantId) {
    
    this.withoutTenantId = withoutTenantId;
    return this;
  }

   /**
   * Only include historic activity instances that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return withoutTenantId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Only include historic activity instances that belong to no tenant. Value may only be `true`, as `false` is the default behavior.")

  public Boolean getWithoutTenantId() {
    return withoutTenantId;
  }


  public void setWithoutTenantId(Boolean withoutTenantId) {
    this.withoutTenantId = withoutTenantId;
  }


  public HistoricActivityInstanceQueryDto sorting(List<HistoricActivityInstanceQueryDtoSorting> sorting) {
    
    this.sorting = sorting;
    return this;
  }

  public HistoricActivityInstanceQueryDto addSortingItem(HistoricActivityInstanceQueryDtoSorting sortingItem) {
    if (this.sorting == null) {
      this.sorting = new ArrayList<HistoricActivityInstanceQueryDtoSorting>();
    }
    this.sorting.add(sortingItem);
    return this;
  }

   /**
   * Apply sorting of the result
   * @return sorting
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Apply sorting of the result")

  public List<HistoricActivityInstanceQueryDtoSorting> getSorting() {
    return sorting;
  }


  public void setSorting(List<HistoricActivityInstanceQueryDtoSorting> sorting) {
    this.sorting = sorting;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HistoricActivityInstanceQueryDto historicActivityInstanceQueryDto = (HistoricActivityInstanceQueryDto) o;
    return Objects.equals(this.activityInstanceId, historicActivityInstanceQueryDto.activityInstanceId) &&
        Objects.equals(this.processInstanceId, historicActivityInstanceQueryDto.processInstanceId) &&
        Objects.equals(this.processDefinitionId, historicActivityInstanceQueryDto.processDefinitionId) &&
        Objects.equals(this.executionId, historicActivityInstanceQueryDto.executionId) &&
        Objects.equals(this.activityId, historicActivityInstanceQueryDto.activityId) &&
        Objects.equals(this.activityName, historicActivityInstanceQueryDto.activityName) &&
        Objects.equals(this.activityType, historicActivityInstanceQueryDto.activityType) &&
        Objects.equals(this.taskAssignee, historicActivityInstanceQueryDto.taskAssignee) &&
        Objects.equals(this.finished, historicActivityInstanceQueryDto.finished) &&
        Objects.equals(this.unfinished, historicActivityInstanceQueryDto.unfinished) &&
        Objects.equals(this.canceled, historicActivityInstanceQueryDto.canceled) &&
        Objects.equals(this.completeScope, historicActivityInstanceQueryDto.completeScope) &&
        Objects.equals(this.startedBefore, historicActivityInstanceQueryDto.startedBefore) &&
        Objects.equals(this.startedAfter, historicActivityInstanceQueryDto.startedAfter) &&
        Objects.equals(this.finishedBefore, historicActivityInstanceQueryDto.finishedBefore) &&
        Objects.equals(this.finishedAfter, historicActivityInstanceQueryDto.finishedAfter) &&
        Objects.equals(this.tenantIdIn, historicActivityInstanceQueryDto.tenantIdIn) &&
        Objects.equals(this.withoutTenantId, historicActivityInstanceQueryDto.withoutTenantId) &&
        Objects.equals(this.sorting, historicActivityInstanceQueryDto.sorting);
  }

  @Override
  public int hashCode() {
    return Objects.hash(activityInstanceId, processInstanceId, processDefinitionId, executionId, activityId, activityName, activityType, taskAssignee, finished, unfinished, canceled, completeScope, startedBefore, startedAfter, finishedBefore, finishedAfter, tenantIdIn, withoutTenantId, sorting);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HistoricActivityInstanceQueryDto {\n");
    sb.append("    activityInstanceId: ").append(toIndentedString(activityInstanceId)).append("\n");
    sb.append("    processInstanceId: ").append(toIndentedString(processInstanceId)).append("\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    executionId: ").append(toIndentedString(executionId)).append("\n");
    sb.append("    activityId: ").append(toIndentedString(activityId)).append("\n");
    sb.append("    activityName: ").append(toIndentedString(activityName)).append("\n");
    sb.append("    activityType: ").append(toIndentedString(activityType)).append("\n");
    sb.append("    taskAssignee: ").append(toIndentedString(taskAssignee)).append("\n");
    sb.append("    finished: ").append(toIndentedString(finished)).append("\n");
    sb.append("    unfinished: ").append(toIndentedString(unfinished)).append("\n");
    sb.append("    canceled: ").append(toIndentedString(canceled)).append("\n");
    sb.append("    completeScope: ").append(toIndentedString(completeScope)).append("\n");
    sb.append("    startedBefore: ").append(toIndentedString(startedBefore)).append("\n");
    sb.append("    startedAfter: ").append(toIndentedString(startedAfter)).append("\n");
    sb.append("    finishedBefore: ").append(toIndentedString(finishedBefore)).append("\n");
    sb.append("    finishedAfter: ").append(toIndentedString(finishedAfter)).append("\n");
    sb.append("    tenantIdIn: ").append(toIndentedString(tenantIdIn)).append("\n");
    sb.append("    withoutTenantId: ").append(toIndentedString(withoutTenantId)).append("\n");
    sb.append("    sorting: ").append(toIndentedString(sorting)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

